/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.io.Files;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.FormatterStep;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.build.event.BuildEventsListenerRegistry;

public abstract class RegisterDependenciesTask
extends DefaultTask {
    static final String TASK_NAME = "spotlessInternalRegisterDependencies";
    List<FormatterStep> steps = new ArrayList<FormatterStep>();
    File unitOutput;

    void hookSubprojectTask(SpotlessTask task) {
        task.dependsOn(new Object[]{this});
    }

    void setup() {
        Preconditions.checkArgument((this.getProject().getRootProject() == this.getProject() ? 1 : 0) != 0, (Object)"Can only be used on the root project");
        String compositeBuildSuffix = this.getName().substring(TASK_NAME.length());
        BuildServiceRegistry buildServices = this.getProject().getGradle().getSharedServices();
        this.getTaskService().set(buildServices.registerIfAbsent("SpotlessTaskService" + compositeBuildSuffix, SpotlessTaskService.class, spec -> {}));
        this.getBuildEventsListenerRegistry().onTaskCompletion(this.getTaskService());
        this.unitOutput = new File(this.getProject().getBuildDir(), "tmp/spotless-register-dependencies");
    }

    @Input
    public List<FormatterStep> getSteps() {
        return this.steps;
    }

    @OutputFile
    public File getUnitOutput() {
        return this.unitOutput;
    }

    @TaskAction
    public void trivialFunction() throws IOException {
        Files.createParentDirs((File)this.unitOutput);
        Files.write((CharSequence)Integer.toString(1), (File)this.unitOutput, (Charset)StandardCharsets.UTF_8);
    }

    @Internal
    abstract Property<SpotlessTaskService> getTaskService();

    @Inject
    protected abstract BuildEventsListenerRegistry getBuildEventsListenerRegistry();
}

