/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableSortedMap;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.JvmLang;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.DiktatStep;
import com.diffplug.spotless.kotlin.KtLintStep;
import com.diffplug.spotless.kotlin.KtfmtStep;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;

public class KotlinExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense,
JvmLang {
    static final String NAME = "kotlin";

    @Inject
    public KotlinExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "(package |@file|import )");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "(package |@file|import )");
    }

    public KotlinFormatExtension ktlint(String version) throws IOException {
        Objects.requireNonNull(version);
        File defaultEditorConfig = this.getProject().getRootProject().file((Object)".editorconfig");
        FileSignature editorConfigPath = defaultEditorConfig.exists() ? FileSignature.signAsList((File[])new File[]{defaultEditorConfig}) : null;
        return new KotlinFormatExtension(version, false, editorConfigPath, Collections.emptyMap(), Collections.emptyMap());
    }

    public KotlinFormatExtension ktlint() throws IOException {
        return this.ktlint(KtLintStep.defaultVersion());
    }

    public KtfmtConfig ktfmt() {
        return this.ktfmt(KtfmtStep.defaultVersion());
    }

    public KtfmtConfig ktfmt(String version) {
        Objects.requireNonNull(version);
        return new KtfmtConfig(version);
    }

    public DiktatFormatExtension diktat(String version) {
        Objects.requireNonNull(version);
        return new DiktatFormatExtension(version);
    }

    public DiktatFormatExtension diktat() {
        return this.diktat(DiktatStep.defaultVersionDiktat());
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.getSources(this.getProject(), "You must either specify 'target' manually or apply a kotlin plugin.", SourceSet::getAllSource, (Spec<? super File>)((Spec)file -> {
                String name = file.getName();
                return name.endsWith(".kt") || name.endsWith(".kts");
            }));
        }
        super.setupTask(task);
    }

    public class DiktatFormatExtension {
        private final String version;
        private FileSignature config;

        DiktatFormatExtension(String version) {
            this.version = version;
            KotlinExtension.this.addStep(this.createStep());
        }

        public DiktatFormatExtension configFile(Object file) throws IOException {
            this.config = file == null ? null : FileSignature.signAsList((File[])new File[]{KotlinExtension.this.getProject().file(file)});
            KotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return DiktatStep.create((String)this.version, (Provisioner)KotlinExtension.this.provisioner(), (FileSignature)this.config);
        }
    }

    public class KtfmtConfig {
        final String version;
        KtfmtStep.Style style;
        KtfmtStep.KtfmtFormattingOptions options;
        private final ConfigurableStyle configurableStyle = new ConfigurableStyle();

        KtfmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            KotlinExtension.this.addStep(this.createStep());
        }

        private ConfigurableStyle style(KtfmtStep.Style style) {
            this.style = style;
            KotlinExtension.this.replaceStep(this.createStep());
            return this.configurableStyle;
        }

        public ConfigurableStyle dropboxStyle() {
            return this.style(KtfmtStep.Style.DROPBOX);
        }

        public ConfigurableStyle googleStyle() {
            return this.style(KtfmtStep.Style.GOOGLE);
        }

        public ConfigurableStyle kotlinlangStyle() {
            return this.style(KtfmtStep.Style.KOTLINLANG);
        }

        public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
            this.configurableStyle.configure(optionsConfiguration);
        }

        private FormatterStep createStep() {
            return KtfmtStep.create((String)this.version, (Provisioner)KotlinExtension.this.provisioner(), (KtfmtStep.Style)this.style, (KtfmtStep.KtfmtFormattingOptions)this.options);
        }

        public class ConfigurableStyle {
            public void configure(Consumer<KtfmtStep.KtfmtFormattingOptions> optionsConfiguration) {
                KtfmtStep.KtfmtFormattingOptions ktfmtFormattingOptions = new KtfmtStep.KtfmtFormattingOptions();
                optionsConfiguration.accept(ktfmtFormattingOptions);
                KtfmtConfig.this.options = ktfmtFormattingOptions;
                KotlinExtension.this.replaceStep(KtfmtConfig.this.createStep());
            }
        }
    }

    public class KotlinFormatExtension {
        private final String version;
        private boolean useExperimental;
        @Nullable
        private FileSignature editorConfigPath;
        private Map<String, String> userData;
        private Map<String, Object> editorConfigOverride;

        KotlinFormatExtension(String version, @Nullable boolean useExperimental, FileSignature editorConfigPath, Map<String, String> config, Map<String, Object> editorConfigOverride) {
            this.version = version;
            this.useExperimental = useExperimental;
            this.editorConfigPath = editorConfigPath;
            this.userData = config;
            this.editorConfigOverride = editorConfigOverride;
            KotlinExtension.this.addStep(this.createStep());
        }

        public KotlinFormatExtension setUseExperimental(boolean useExperimental) {
            this.useExperimental = useExperimental;
            KotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KotlinFormatExtension setEditorConfigPath(Object editorConfigFile) throws IOException {
            this.editorConfigPath = editorConfigFile == null ? null : FileSignature.signAsList((File[])new File[]{KotlinExtension.this.getProject().file(editorConfigFile)});
            KotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KotlinFormatExtension userData(Map<String, String> userData) {
            this.userData = ImmutableSortedMap.copyOf(userData);
            KotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        public KotlinFormatExtension editorConfigOverride(Map<String, Object> editorConfigOverride) {
            this.editorConfigOverride = ImmutableSortedMap.copyOf(editorConfigOverride);
            KotlinExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return KtLintStep.create((String)this.version, (Provisioner)KotlinExtension.this.provisioner(), (boolean)this.useExperimental, (boolean)false, (FileSignature)this.editorConfigPath, this.userData, this.editorConfigOverride);
        }
    }
}

