/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.JvmLocalCache;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.Incremental;

public abstract class SpotlessTask
extends DefaultTask {
    protected String encoding = "UTF-8";
    protected final JvmLocalCache.LiveCache<LineEnding.Policy> lineEndingsPolicy = this.createLive("lineEndingsPolicy");
    private transient ObjectId rootTreeSha;
    private transient ObjectId subtreeSha = ObjectId.zeroId();
    protected String ratchetFrom;
    protected FormatExceptionPolicy exceptionPolicy = new FormatExceptionPolicyStrict();
    protected FileCollection target;
    protected File outputDirectory = new File(this.getProject().getBuildDir(), "spotless/" + this.getName());
    protected final JvmLocalCache.LiveCache<List<FormatterStep>> steps = this.createLive("steps");

    public SpotlessTask() {
        this.steps.set(new ArrayList());
    }

    @Internal
    abstract Property<SpotlessTaskService> getTaskService();

    protected <T> JvmLocalCache.LiveCache<T> createLive(String keyName) {
        return JvmLocalCache.createLive((Task)this, keyName);
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    @Input
    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy.get();
    }

    public void setLineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
        this.lineEndingsPolicy.set(lineEndingsPolicy);
    }

    public void setupRatchet(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
        if (!ratchetFrom.isEmpty()) {
            GitRatchetGradle ratchet = ((SpotlessTaskService)this.getTaskService().get()).getRatchet();
            File projectDir = ((Directory)this.getProjectDir().get()).getAsFile();
            this.rootTreeSha = ratchet.rootTreeShaOf(projectDir, ratchetFrom);
            this.subtreeSha = ratchet.subtreeShaOf(projectDir, this.rootTreeSha);
        } else {
            this.subtreeSha = ObjectId.zeroId();
        }
    }

    @Internal
    abstract DirectoryProperty getProjectDir();

    @Internal
    GitRatchetGradle getRatchet() {
        return ObjectId.zeroId().equals((AnyObjectId)this.getRatchetSha()) ? null : ((SpotlessTaskService)this.getTaskService().get()).getRatchet();
    }

    @Internal
    ObjectId getRootTreeSha() {
        return this.rootTreeSha;
    }

    @Input
    public ObjectId getRatchetSha() {
        if (this.subtreeSha == null) {
            this.setupRatchet(this.ratchetFrom);
        }
        return this.subtreeSha;
    }

    public void setExceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy);
    }

    @Input
    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @InputFiles
    public FileCollection getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = target instanceof FileCollection ? (FileCollection)target : this.getProject().files(new Object[]{target});
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public List<FormatterStep> getSteps() {
        return Collections.unmodifiableList(this.steps.get());
    }

    public void setSteps(List<FormatterStep> steps) {
        this.steps.set(PluginGradlePreconditions.requireElementsNonNull(steps));
    }

    public boolean addStep(FormatterStep step) {
        return this.steps.get().add(Objects.requireNonNull(step));
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    Formatter buildFormatter() {
        return Formatter.builder().lineEndingsPolicy(this.lineEndingsPolicy.get()).encoding(Charset.forName(this.encoding)).rootDir(((Directory)this.getProjectDir().get()).getAsFile().toPath()).steps(this.steps.get()).exceptionPolicy(this.exceptionPolicy).build();
    }
}

