/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.LazyForwardingEquality;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Task;

class JvmLocalCache {
    private static Map<InternalCacheKey, Object> daemonState = Collections.synchronizedMap(new HashMap());

    JvmLocalCache() {
    }

    private static GradleException cacheIsStale() {
        return new GradleException("Spotless JVM-local cache is stale. Regenerate the cache with\n  " + (FileSignature.machineIsWin() ? "rmdir /q /s" : "rm -rf") + " .gradle/configuration-cache\nTo make this workaround obsolete, please upvote https://github.com/diffplug/spotless/issues/987");
    }

    static <T> LiveCache<T> createLive(Task task, String propertyName) {
        return new LiveCacheKeyImpl(new InternalCacheKey(task.getProject().getProjectDir(), task.getPath(), propertyName));
    }

    private static class InternalCacheKey
    implements Serializable {
        private File projectDir;
        private String taskPath;
        private String propertyName;

        InternalCacheKey(File projectDir, String taskPath, String keyName) {
            this.projectDir = projectDir;
            this.taskPath = taskPath;
            this.propertyName = keyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternalCacheKey that = (InternalCacheKey)o;
            return this.projectDir.equals(that.projectDir) && this.taskPath.equals(that.taskPath) && this.propertyName.equals(that.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.projectDir, this.taskPath, this.propertyName);
        }
    }

    static class LiveCacheKeyImpl<T>
    implements LiveCache<T>,
    Serializable {
        InternalCacheKey internalKey;

        LiveCacheKeyImpl(InternalCacheKey internalKey) {
            this.internalKey = internalKey;
        }

        @Override
        public void set(T value) {
            LazyForwardingEquality.unlazy(value);
            daemonState.put(this.internalKey, value);
        }

        @Override
        public T get() {
            Object value = daemonState.get(this.internalKey);
            if (value == null) {
                throw JvmLocalCache.cacheIsStale();
            }
            return (T)value;
        }
    }

    static interface LiveCache<T> {
        public T get();

        public void set(T var1);
    }
}

