/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.pom.SortPomCfg;
import com.diffplug.spotless.pom.SortPomStep;
import java.util.Objects;
import javax.inject.Inject;

public class PomExtension
extends FormatExtension {
    private static final String POM_FILE = "pom.xml";
    static final String NAME = "pom";

    @Inject
    public PomExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget(POM_FILE);
        }
        super.setupTask(task);
    }

    public SortPomGradleConfig sortPom() {
        return new SortPomGradleConfig();
    }

    public SortPomGradleConfig sortPom(String version) {
        Objects.requireNonNull(version);
        return new SortPomGradleConfig(version);
    }

    public class SortPomGradleConfig {
        private final SortPomCfg cfg = new SortPomCfg();

        SortPomGradleConfig() {
            PomExtension.this.addStep(this.createStep());
        }

        SortPomGradleConfig(String version) {
            this();
            this.cfg.version = Objects.requireNonNull(version);
        }

        public SortPomGradleConfig encoding(String encoding) {
            this.cfg.encoding = encoding;
            return this;
        }

        public SortPomGradleConfig lineSeparator(String lineSeparator) {
            this.cfg.lineSeparator = lineSeparator;
            return this;
        }

        public SortPomGradleConfig expandEmptyElements(boolean expandEmptyElements) {
            this.cfg.expandEmptyElements = expandEmptyElements;
            return this;
        }

        public SortPomGradleConfig spaceBeforeCloseEmptyElement(boolean spaceBeforeCloseEmptyElement) {
            this.cfg.spaceBeforeCloseEmptyElement = spaceBeforeCloseEmptyElement;
            return this;
        }

        public SortPomGradleConfig keepBlankLines(boolean keepBlankLines) {
            this.cfg.keepBlankLines = keepBlankLines;
            return this;
        }

        public SortPomGradleConfig endWithNewline(boolean endWithNewline) {
            this.cfg.endWithNewline = endWithNewline;
            return this;
        }

        public SortPomGradleConfig nrOfIndentSpace(int nrOfIndentSpace) {
            this.cfg.nrOfIndentSpace = nrOfIndentSpace;
            return this;
        }

        public SortPomGradleConfig indentBlankLines(boolean indentBlankLines) {
            this.cfg.indentBlankLines = indentBlankLines;
            return this;
        }

        public SortPomGradleConfig indentSchemaLocation(boolean indentSchemaLocation) {
            this.cfg.indentSchemaLocation = indentSchemaLocation;
            return this;
        }

        public SortPomGradleConfig indentAttribute(String indentAttribute) {
            this.cfg.indentAttribute = indentAttribute;
            return this;
        }

        public SortPomGradleConfig predefinedSortOrder(String predefinedSortOrder) {
            this.cfg.predefinedSortOrder = predefinedSortOrder;
            return this;
        }

        public SortPomGradleConfig sortOrderFile(String sortOrderFile) {
            this.cfg.sortOrderFile = sortOrderFile;
            return this;
        }

        public SortPomGradleConfig sortDependencies(String sortDependencies) {
            this.cfg.sortDependencies = sortDependencies;
            return this;
        }

        public SortPomGradleConfig sortDependencyManagement(String sortDependencyManagement) {
            this.cfg.sortDependencyManagement = sortDependencyManagement;
            return this;
        }

        public SortPomGradleConfig sortDependencyExclusions(String sortDependencyExclusions) {
            this.cfg.sortDependencyExclusions = sortDependencyExclusions;
            return this;
        }

        public SortPomGradleConfig sortPlugins(String sortPlugins) {
            this.cfg.sortPlugins = sortPlugins;
            return this;
        }

        public SortPomGradleConfig sortProperties(boolean sortProperties) {
            this.cfg.sortProperties = sortProperties;
            return this;
        }

        public SortPomGradleConfig sortModules(boolean sortModules) {
            this.cfg.sortModules = sortModules;
            return this;
        }

        public SortPomGradleConfig sortExecutions(boolean sortExecutions) {
            this.cfg.sortExecutions = sortExecutions;
            return this;
        }

        private FormatterStep createStep() {
            return SortPomStep.create((SortPomCfg)this.cfg, (Provisioner)PomExtension.this.provisioner());
        }
    }
}

