/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.cpp.CppDefaults;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import com.diffplug.spotless.extra.cpp.EclipseCdtFormatterStep;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Project;

public class CppExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "cpp";

    @Inject
    public CppExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public EclipseConfig eclipseCdt() {
        return this.eclipseCdt(EclipseCdtFormatterStep.defaultVersion());
    }

    public EclipseConfig eclipseCdt(String version) {
        return new EclipseConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, CppDefaults.DELIMITER_EXPR);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, CppDefaults.DELIMITER_EXPR);
    }

    public class EclipseConfig {
        private final EquoBasedStepBuilder builder;

        EclipseConfig(String version) {
            this.builder = EclipseCdtFormatterStep.createBuilder((Provisioner)CppExtension.this.provisioner());
            this.builder.setVersion(version);
            CppExtension.this.addStep(this.builder.build());
        }

        public EclipseConfig configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = CppExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            CppExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig withP2Mirrors(Map<String, String> mirrors) {
            this.builder.setP2Mirrors(mirrors);
            CppExtension.this.replaceStep(this.builder.build());
            return this;
        }
    }
}

