/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.Antlr4Extension;
import com.diffplug.gradle.spotless.CppExtension;
import com.diffplug.gradle.spotless.FlexmarkExtension;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.FreshMarkExtension;
import com.diffplug.gradle.spotless.GherkinExtension;
import com.diffplug.gradle.spotless.GoExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.GroovyExtension;
import com.diffplug.gradle.spotless.GroovyGradleExtension;
import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.JavascriptExtension;
import com.diffplug.gradle.spotless.JsonExtension;
import com.diffplug.gradle.spotless.KotlinExtension;
import com.diffplug.gradle.spotless.KotlinGradleExtension;
import com.diffplug.gradle.spotless.PomExtension;
import com.diffplug.gradle.spotless.ProtobufExtension;
import com.diffplug.gradle.spotless.PythonExtension;
import com.diffplug.gradle.spotless.RegisterDependenciesTask;
import com.diffplug.gradle.spotless.ScalaExtension;
import com.diffplug.gradle.spotless.ShellExtension;
import com.diffplug.gradle.spotless.SpotlessExtensionPredeclare;
import com.diffplug.gradle.spotless.SqlExtension;
import com.diffplug.gradle.spotless.TypescriptExtension;
import com.diffplug.gradle.spotless.YamlExtension;
import com.diffplug.spotless.LineEnding;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class SpotlessExtension {
    final Project project;
    private final RegisterDependenciesTask registerDependenciesTask;
    protected static final String TASK_GROUP = "verification";
    protected static final String CHECK_DESCRIPTION = "Checks that sourcecode satisfies formatting steps.";
    protected static final String APPLY_DESCRIPTION = "Applies code formatting steps to sourcecode in-place.";
    static final String EXTENSION = "spotless";
    static final String EXTENSION_PREDECLARE = "spotlessPredeclare";
    static final String CHECK = "Check";
    static final String APPLY = "Apply";
    static final String DIAGNOSE = "Diagnose";
    LineEnding lineEndings = LineEnding.GIT_ATTRIBUTES_FAST_ALLSAME;
    Charset encoding = StandardCharsets.UTF_8;
    @Nullable
    private String ratchetFrom;
    final Map<String, FormatExtension> formats = new LinkedHashMap<String, FormatExtension>();
    boolean enforceCheck = true;

    protected SpotlessExtension(Project project) {
        this.project = Objects.requireNonNull(project);
        this.registerDependenciesTask = (RegisterDependenciesTask)((Object)this.findRegisterDepsTask().get());
    }

    RegisterDependenciesTask getRegisterDependenciesTask() {
        return this.registerDependenciesTask;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        if (lineEndings == LineEnding.GIT_ATTRIBUTES) {
            throw new IllegalArgumentException("GIT_ATTRIBUTES not supported in Gradle, use GIT_ATTRIBUTES_FAST_ALLSAME instead. See https://github.com/diffplug/spotless/issues/1274 for more details.");
        }
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void setEncoding(String name) {
        Objects.requireNonNull(name);
        this.setEncoding(Charset.forName(name));
    }

    public void encoding(Charset charset) {
        this.setEncoding(charset);
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void setRatchetFrom(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
    }

    @Nullable
    public String getRatchetFrom() {
        return this.ratchetFrom;
    }

    public void ratchetFrom(String ratchetFrom) {
        this.setRatchetFrom(ratchetFrom);
    }

    public void java(Action<JavaExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("java", JavaExtension.class, closure);
    }

    public void scala(Action<ScalaExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("scala", ScalaExtension.class, closure);
    }

    public void kotlin(Action<KotlinExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("kotlin", KotlinExtension.class, closure);
    }

    public void kotlinGradle(Action<KotlinGradleExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("kotlinGradle", KotlinGradleExtension.class, closure);
    }

    public void freshmark(Action<FreshMarkExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("freshmark", FreshMarkExtension.class, closure);
    }

    public void flexmark(Action<FlexmarkExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("flexmark", FlexmarkExtension.class, closure);
    }

    public void groovy(Action<GroovyExtension> closure) {
        this.format("groovy", GroovyExtension.class, closure);
    }

    public void groovyGradle(Action<GroovyGradleExtension> closure) {
        this.format("groovyGradle", GroovyGradleExtension.class, closure);
    }

    public void sql(Action<SqlExtension> closure) {
        this.format("sql", SqlExtension.class, closure);
    }

    public void cpp(Action<CppExtension> closure) {
        this.format("cpp", CppExtension.class, closure);
    }

    public void javascript(Action<JavascriptExtension> closure) {
        this.format("javascript", JavascriptExtension.class, closure);
    }

    public void typescript(Action<TypescriptExtension> closure) {
        this.format("typescript", TypescriptExtension.class, closure);
    }

    public void antlr4(Action<Antlr4Extension> closure) {
        this.format("antlr4", Antlr4Extension.class, closure);
    }

    public void python(Action<PythonExtension> closure) {
        this.format("python", PythonExtension.class, closure);
    }

    public void json(Action<JsonExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("json", JsonExtension.class, closure);
    }

    public void protobuf(Action<ProtobufExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("protobuf", ProtobufExtension.class, closure);
    }

    public void shell(Action<ShellExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("shell", ShellExtension.class, closure);
    }

    public void yaml(Action<YamlExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("yaml", YamlExtension.class, closure);
    }

    public void gherkin(Action<GherkinExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("gherkin", GherkinExtension.class, closure);
    }

    public void go(Action<GoExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("go", GoExtension.class, closure);
    }

    public void pom(Action<PomExtension> closure) {
        Objects.requireNonNull(closure);
        this.format("pom", PomExtension.class, closure);
    }

    public void format(String name, Action<FormatExtension> closure) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(closure, "closure");
        this.format(name, FormatExtension.class, closure);
    }

    public boolean isEnforceCheck() {
        return this.enforceCheck;
    }

    public void setEnforceCheck(boolean enforceCheck) {
        this.enforceCheck = enforceCheck;
    }

    public <T extends FormatExtension> void format(String name, Class<T> clazz, Action<T> configure) {
        ((FormatExtension)this.maybeCreate((String)name, clazz)).lazyActions.add(configure);
    }

    protected final <T extends FormatExtension> T maybeCreate(String name, Class<T> clazz) {
        FormatExtension existing = this.formats.get(name);
        if (existing != null) {
            if (!clazz.isInstance(existing)) {
                throw new GradleException("Tried to add format named '" + name + "' of type " + clazz + " but one has already been created of type " + existing.getClass());
            }
            return (T)existing;
        }
        T formatExtension = this.instantiateFormatExtension(clazz);
        this.formats.put(name, (FormatExtension)formatExtension);
        this.createFormatTasks(name, (FormatExtension)formatExtension);
        return formatExtension;
    }

    <T extends FormatExtension> T instantiateFormatExtension(Class<T> clazz) {
        try {
            return (T)((FormatExtension)this.project.getObjects().newInstance(clazz, new Object[]{this}));
        }
        catch (Exception e) {
            throw new GradleException("Must have a constructor " + clazz.getSimpleName() + "(SpotlessExtension root), annotated with @javax.inject.Inject", (Throwable)e);
        }
    }

    protected abstract void createFormatTasks(String var1, FormatExtension var2);

    TaskProvider<RegisterDependenciesTask> findRegisterDepsTask() {
        try {
            return this.findRegisterDepsTask("spotlessInternalRegisterDependencies");
        }
        catch (Exception e) {
            return this.findRegisterDepsTask("spotlessInternalRegisterDependencies" + System.identityHashCode(RegisterDependenciesTask.class));
        }
    }

    private TaskProvider<RegisterDependenciesTask> findRegisterDepsTask(String taskName) {
        TaskContainer rootProjectTasks = this.project.getRootProject().getTasks();
        if (!rootProjectTasks.getNames().contains(taskName)) {
            return rootProjectTasks.register(taskName, RegisterDependenciesTask.class, RegisterDependenciesTask::setup);
        }
        return rootProjectTasks.named(taskName, RegisterDependenciesTask.class);
    }

    public void predeclareDepsFromBuildscript() {
        if (this.project.getRootProject() != this.project) {
            throw new GradleException("predeclareDepsFromBuildscript can only be called from the root project");
        }
        this.predeclare(GradleProvisioner.Policy.ROOT_BUILDSCRIPT);
    }

    public void predeclareDeps() {
        if (this.project.getRootProject() != this.project) {
            throw new GradleException("predeclareDeps can only be called from the root project");
        }
        this.predeclare(GradleProvisioner.Policy.ROOT_PROJECT);
    }

    protected void predeclare(GradleProvisioner.Policy policy) {
        this.project.getExtensions().create(SpotlessExtensionPredeclare.class, EXTENSION_PREDECLARE, SpotlessExtensionPredeclare.class, new Object[]{this.project, policy});
    }
}

