/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Preconditions;
import com.diffplug.gradle.spotless.BiomeStepConfig;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPluginRedirect;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.LintSuppression;
import com.diffplug.spotless.OnMatch;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.biome.BiomeFlavor;
import com.diffplug.spotless.cpp.ClangFormatStep;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.wtp.EclipseWtpFormatterStep;
import com.diffplug.spotless.generic.EndWithNewlineStep;
import com.diffplug.spotless.generic.FenceStep;
import com.diffplug.spotless.generic.IndentStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.generic.NativeCmdStep;
import com.diffplug.spotless.generic.ReplaceRegexStep;
import com.diffplug.spotless.generic.ReplaceStep;
import com.diffplug.spotless.generic.TrimTrailingWhitespaceStep;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import groovy.lang.Closure;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;

public class FormatExtension {
    final SpotlessExtension spotless;
    final List<Action<FormatExtension>> lazyActions = new ArrayList<Action<FormatExtension>>();
    LineEnding lineEndings;
    Charset encoding;
    private static final String RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL = " not set at format level ";
    private String ratchetFrom = " not set at format level ";
    final List<LintSuppression> lintSuppressions = new ArrayList<LintSuppression>();
    protected FileCollection target;
    protected FileCollection targetExclude;
    @Nullable
    protected String targetExcludeContentPattern = null;
    protected final List<FormatterStep> steps = new ArrayList<FormatterStep>();
    private Serializable globalState = new NeverUpToDateBetweenRuns();
    @Nullable
    private FenceStep toggleFence;

    @Inject
    public FormatExtension(SpotlessExtension spotless) {
        this.spotless = Objects.requireNonNull(spotless);
    }

    protected final Provisioner provisioner() {
        return ((SpotlessTaskService)this.spotless.getRegisterDependenciesTask().getTaskService().get()).provisionerFor(this.spotless);
    }

    private String formatName() {
        for (Map.Entry<String, FormatExtension> entry : this.spotless.formats.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("This format is not contained by any SpotlessExtension.");
    }

    public LineEnding getLineEndings() {
        return this.lineEndings == null ? this.spotless.getLineEndings() : this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding == null ? this.spotless.getEncoding() : this.encoding;
    }

    public void setEncoding(String name) {
        this.setEncoding(Charset.forName(Objects.requireNonNull(name)));
    }

    public String getRatchetFrom() {
        return this.ratchetFrom == RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL ? this.spotless.getRatchetFrom() : this.ratchetFrom;
    }

    public void setRatchetFrom(String ratchetFrom) {
        this.ratchetFrom = ratchetFrom;
    }

    public void ratchetFrom(String ratchetFrom) {
        this.setRatchetFrom(ratchetFrom);
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void suppressLintsFor(Action<LintSuppression> lintSuppression) {
        LintSuppression suppression = new LintSuppression();
        lintSuppression.execute((Object)suppression);
        suppression.ensureDoesNotSuppressAll();
        this.lintSuppressions.add(suppression);
    }

    @Deprecated
    public void ignoreErrorForStep(String stepName) {
        System.err.println("`ignoreErrorForStep('" + stepName + "') is deprecated, use `suppressLintsFor { step = '" + stepName + "' }` instead.");
        this.suppressLintsFor((Action<LintSuppression>)((Action)it -> it.setStep(stepName)));
    }

    @Deprecated
    public void ignoreErrorForPath(String relativePath) {
        System.err.println("`ignoreErrorForPath('" + relativePath + "') is deprecated, use `suppressLintsFor { path = '" + relativePath + "' }` instead.");
        this.suppressLintsFor((Action<LintSuppression>)((Action)it -> it.setPath(relativePath)));
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    protected boolean isLicenseHeaderStep(FormatterStep formatterStep) {
        String formatterStepName = formatterStep.getName();
        return formatterStepName.startsWith(LicenseHeaderStep.class.getName());
    }

    public void target(Object ... targets) {
        this.target = this.parseTargetsIsExclude(targets, false);
    }

    public void targetExclude(Object ... targets) {
        this.targetExclude = this.parseTargetsIsExclude(targets, true);
    }

    public void targetExcludeIfContentContains(String string) {
        this.targetExcludeIfContentContainsRegex(Pattern.quote(string));
    }

    public void targetExcludeIfContentContainsRegex(String regex) {
        this.targetExcludeContentPattern = regex;
    }

    private FileCollection parseTargetsIsExclude(Object[] targets, boolean isExclude) {
        PluginGradlePreconditions.requireElementsNonNull(targets);
        if (targets.length == 0) {
            return this.getProject().files(new Object[0]);
        }
        if (targets.length == 1) {
            return this.parseTargetIsExclude(targets[0], isExclude);
        }
        ConfigurableFileCollection union = this.getProject().files(new Object[0]);
        for (Object target : targets) {
            union = union.plus(this.parseTargetIsExclude(target, isExclude));
        }
        return union;
    }

    protected final FileCollection parseTarget(Object target) {
        return this.parseTargetIsExclude(target, false);
    }

    private final FileCollection parseTargetIsExclude(Object target, boolean isExclude) {
        if (target instanceof Collection) {
            return this.parseTargetsIsExclude(((Collection)target).toArray(), isExclude);
        }
        if (target instanceof FileCollection) {
            return (FileCollection)target;
        }
        if (target instanceof String) {
            File dir = this.getProject().getProjectDir();
            ConfigurableFileTree matchedFiles = this.getProject().fileTree((Object)dir);
            String targetString = (String)target;
            matchedFiles.include(new String[]{targetString});
            if (isExclude) {
                return matchedFiles;
            }
            if (targetString.startsWith("**/") || targetString.startsWith("**\\")) {
                ArrayList<String> excludes = new ArrayList<String>();
                excludes.add(".git");
                if (this.getProject() == this.getProject().getRootProject()) {
                    excludes.add(".gradle");
                }
                FormatExtension.relativizeIfSubdir(excludes, dir, (File)this.getProject().getLayout().getBuildDirectory().getAsFile().get());
                for (Project subproject : this.getProject().getSubprojects()) {
                    FormatExtension.relativizeIfSubdir(excludes, dir, (File)subproject.getLayout().getBuildDirectory().getAsFile().get());
                }
                matchedFiles.exclude(excludes);
            }
            return matchedFiles;
        }
        return this.getProject().files(new Object[]{target});
    }

    private static void relativizeIfSubdir(List<String> relativePaths, File root, File dest) {
        String relativized = FormatExtension.relativize(root, dest);
        if (relativized != null) {
            relativePaths.add(relativized);
        }
    }

    @Nullable
    static String relativize(File root, File dest) {
        String rootPath = root.getAbsolutePath();
        String destPath = dest.getAbsolutePath();
        if (!destPath.startsWith(rootPath)) {
            return null;
        }
        String relativized = destPath.substring(rootPath.length());
        return relativized.startsWith("/") || relativized.startsWith("\\") ? relativized.substring(1) : relativized;
    }

    public void addStep(FormatterStep newStep) {
        Objects.requireNonNull(newStep);
        int existingIdx = this.getExistingStepIdx(newStep.getName());
        if (existingIdx != -1) {
            throw new GradleException("Multiple steps with name '" + newStep.getName() + "' for spotless format '" + this.formatName() + "'");
        }
        this.steps.add(newStep);
    }

    public void addStep(Function<Provisioner, FormatterStep> createStepFn) {
        Objects.requireNonNull(createStepFn);
        FormatterStep newStep = createStepFn.apply(this.provisioner());
        this.addStep(newStep);
    }

    protected int getExistingStepIdx(String stepName) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.steps.get(i).getName().equals(stepName)) continue;
            return i;
        }
        return -1;
    }

    protected void replaceStep(FormatterStep replacementStep) {
        int existingIdx = this.getExistingStepIdx(replacementStep.getName());
        if (existingIdx == -1) {
            throw new GradleException("Cannot replace step '" + replacementStep.getName() + "' for spotless format '" + this.formatName() + "' because it hasn't been added yet.");
        }
        this.steps.set(existingIdx, replacementStep);
    }

    public void clearSteps() {
        this.steps.clear();
    }

    public void bumpThisNumberIfACustomStepChanges(int number) {
        this.globalState = Integer.valueOf(number);
    }

    public void custom(String name, Closure<String> formatter) {
        Objects.requireNonNull(formatter, "formatter");
        Closure dehydrated = formatter.dehydrate();
        this.custom(name, new ClosureFormatterFunc((Closure<String>)dehydrated));
    }

    public void custom(String name, FormatterFunc formatter) {
        Objects.requireNonNull(formatter, "formatter");
        if (SpotlessPluginRedirect.badSemverOfGradle() < SpotlessPluginRedirect.badSemver("8.0")) {
            throw new GradleException("The 'custom' method is only available if you are using Gradle 8.0 or newer, this is " + GradleVersion.current().getVersion());
        }
        this.addStep(FormatterStep.createLazy((String)name, () -> this.globalState, (SerializedFunction)SerializedFunction.alwaysReturns((Object)formatter)));
    }

    public void replace(String name, CharSequence original, CharSequence after) {
        this.addStep(ReplaceStep.create((String)name, (CharSequence)original, (CharSequence)after));
    }

    public void replaceRegex(String name, String regex, String replacement) {
        this.addStep(ReplaceRegexStep.create((String)name, (String)regex, (String)replacement));
    }

    public void trimTrailingWhitespace() {
        this.addStep(TrimTrailingWhitespaceStep.create());
    }

    public void endWithNewline() {
        this.addStep(EndWithNewlineStep.create());
    }

    public void indentWithSpaces(int numSpacesPerTab) {
        this.addStep(IndentStep.Type.SPACE.create(numSpacesPerTab));
    }

    public void indentWithSpaces() {
        this.addStep(IndentStep.Type.SPACE.create());
    }

    public void indentWithTabs(int tabToSpaces) {
        this.addStep(IndentStep.Type.TAB.create(tabToSpaces));
    }

    public void indentWithTabs() {
        this.addStep(IndentStep.Type.TAB.create());
    }

    public void nativeCmd(String name, String pathToExe, List<String> arguments) {
        this.addStep(NativeCmdStep.create((String)name, (File)new File(pathToExe), arguments));
    }

    public LicenseHeaderConfig licenseHeader(String licenseHeader, String delimiter) {
        LicenseHeaderConfig config = new LicenseHeaderConfig(LicenseHeaderStep.headerDelimiter((String)licenseHeader, (String)delimiter));
        this.addStep(config.createStep());
        return config;
    }

    public LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile, String delimiter) {
        LicenseHeaderConfig config = new LicenseHeaderConfig(LicenseHeaderStep.headerDelimiter(() -> {
            File file = this.getProject().file(licenseHeaderFile);
            byte[] data = Files.readAllBytes(file.toPath());
            return new String(data, this.getEncoding());
        }, (String)delimiter));
        this.addStep(config.createStep());
        return config;
    }

    public PrettierConfig prettier() {
        return this.prettier(PrettierFormatterStep.defaultDevDependencies());
    }

    public PrettierConfig prettier(String version) {
        return this.prettier(PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)version));
    }

    public PrettierConfig prettier(Map<String, String> devDependencies) {
        PrettierConfig prettierConfig = new PrettierConfig(devDependencies);
        this.addStep(prettierConfig.createStep());
        return prettierConfig;
    }

    public BiomeStepConfig<?> biome() {
        return this.biome(null);
    }

    public BiomeStepConfig<?> biome(String version) {
        BiomeGeneric biomeConfig = new BiomeGeneric(version);
        this.addStep(biomeConfig.createStep());
        return biomeConfig;
    }

    public ClangFormatConfig clangFormat() {
        return this.clangFormat(ClangFormatStep.defaultVersion());
    }

    public ClangFormatConfig clangFormat(String version) {
        return new ClangFormatConfig(version);
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type) {
        return this.eclipseWtp(type, EclipseWtpFormatterStep.defaultVersion());
    }

    public EclipseWtpConfig eclipseWtp(EclipseWtpFormatterStep type, String version) {
        return new EclipseWtpConfig(type, version);
    }

    public void withinBlocks(String name, String open, String close, Action<FormatExtension> configure) {
        this.withinBlocks(name, open, close, FormatExtension.class, configure);
    }

    public <T extends FormatExtension> void withinBlocks(String name, String open, String close, Class<T> clazz, Action<T> configure) {
        this.withinBlocksHelper(FenceStep.named((String)name).openClose(open, close), clazz, configure);
    }

    public void withinBlocksRegex(String name, String regex, Action<FormatExtension> configure) {
        this.withinBlocksRegex(name, regex, FormatExtension.class, configure);
    }

    public <T extends FormatExtension> void withinBlocksRegex(String name, String regex, Class<T> clazz, Action<T> configure) {
        this.withinBlocksHelper(FenceStep.named((String)name).regex(regex), clazz, configure);
    }

    private <T extends FormatExtension> void withinBlocksHelper(FenceStep fence, Class<T> clazz, Action<T> configure) {
        T formatExtension = this.spotless.instantiateFormatExtension(clazz);
        configure.execute(formatExtension);
        FormatterStep step = fence.applyWithin(((FormatExtension)formatExtension).steps);
        this.addStep(step);
    }

    public void toggleOffOnRegex(String regex) {
        this.toggleFence = FenceStep.named((String)FenceStep.defaultToggleName()).regex(regex);
    }

    public void toggleOffOn(String off, String on) {
        this.toggleFence = FenceStep.named((String)FenceStep.defaultToggleName()).openClose(off, on);
    }

    public void toggleOffOn() {
        this.toggleOffOn(FenceStep.defaultToggleOff(), FenceStep.defaultToggleOn());
    }

    public void toggleOffOnDisable() {
        this.toggleFence = null;
    }

    protected void setupTask(SpotlessTask task) {
        task.setEncoding(this.getEncoding().name());
        task.setLintSuppressions(this.lintSuppressions);
        FileCollection totalTarget = this.targetExclude == null ? this.target : this.target.minus(this.targetExclude);
        task.setTarget((Iterable<File>)totalTarget);
        List<FormatterStep> steps = this.toggleFence != null ? List.of(this.toggleFence.preserveWithin(this.steps)) : this.steps;
        if (this.targetExcludeContentPattern != null) {
            steps.replaceAll(formatterStep -> formatterStep.filterByContent(OnMatch.EXCLUDE, this.targetExcludeContentPattern));
        }
        task.setSteps(steps);
        Directory projectDir = this.getProject().getLayout().getProjectDirectory();
        LineEnding lineEndings = this.getLineEndings();
        task.setLineEndingsPolicy((Provider<LineEnding.Policy>)this.getProject().provider(() -> lineEndings.createPolicy(projectDir.getAsFile(), () -> totalTarget)));
        this.spotless.getRegisterDependenciesTask().hookSubprojectTask(task);
        task.setupRatchet(this.getRatchetFrom() != null ? this.getRatchetFrom() : "");
    }

    protected Project getProject() {
        return this.spotless.project;
    }

    public SpotlessApply createIndependentApplyTask(String taskName) {
        return (SpotlessApply)((Object)this.createIndependentApplyTaskLazy(taskName).get());
    }

    public TaskProvider<SpotlessApply> createIndependentApplyTaskLazy(String taskName) {
        Preconditions.checkArgument((!taskName.endsWith("Apply") ? 1 : 0) != 0, (Object)"Task name must not end with Apply");
        TaskProvider spotlessTask = this.spotless.project.getTasks().register(taskName + SpotlessTaskService.INDEPENDENT_HELPER, SpotlessTaskImpl.class, task -> {
            task.init(this.spotless.getRegisterDependenciesTask().getTaskService());
            this.setupTask((SpotlessTask)((Object)task));
            task.mustRunAfter(new Object[]{"clean"});
        });
        TaskProvider applyTask = this.spotless.project.getTasks().register(taskName, SpotlessApply.class, task -> {
            task.dependsOn(new Object[]{spotlessTask});
            task.init((SpotlessTaskImpl)((Object)((Object)spotlessTask.get())));
        });
        return applyTask;
    }

    protected GradleException noDefaultTargetException() {
        return new GradleException("Spotless failure, no target set!  You must set a target for " + this.formatName());
    }

    public class EclipseWtpConfig {
        private final EclipseBasedStepBuilder builder;

        EclipseWtpConfig(EclipseWtpFormatterStep type, String version) {
            this.builder = type.createBuilder(FormatExtension.this.provisioner());
            this.builder.setVersion(version);
            FormatExtension.this.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = FormatExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            FormatExtension.this.replaceStep(this.builder.build());
        }
    }

    public class ClangFormatConfig {
        ClangFormatStep stepCfg;

        ClangFormatConfig(String version) {
            this.stepCfg = ClangFormatStep.withVersion((String)version);
            FormatExtension.this.addStep(this.createStep());
        }

        public ClangFormatConfig style(String style) {
            this.stepCfg = this.stepCfg.withStyle(style);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ClangFormatConfig pathToExe(String pathToBlack) {
            this.stepCfg = this.stepCfg.withPathToExe(pathToBlack);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return this.stepCfg.create();
        }
    }

    public class BiomeGeneric
    extends BiomeStepConfig<BiomeGeneric> {
        @Nullable
        String language;

        public BiomeGeneric(String version) {
            super(FormatExtension.this.getProject(), FormatExtension.this::replaceStep, BiomeFlavor.BIOME, version);
        }

        public BiomeGeneric language(String language) {
            this.language = language;
            this.replaceStep();
            return this;
        }

        @Override
        protected String getLanguage() {
            return this.language;
        }

        @Override
        protected BiomeGeneric getThis() {
            return this;
        }
    }

    public class PrettierConfig
    extends NpmStepConfig<PrettierConfig> {
        @Nullable
        Object prettierConfigFile;
        @Nullable
        Map<String, Object> prettierConfig;
        final Map<String, String> devDependencies;

        PrettierConfig(Map<String, String> devDependencies) {
            super(FormatExtension.this.getProject(), FormatExtension.this::replaceStep);
            this.devDependencies = Objects.requireNonNull(devDependencies);
        }

        public PrettierConfig configFile(Object prettierConfigFile) {
            this.prettierConfigFile = prettierConfigFile;
            this.replaceStep();
            return this;
        }

        public PrettierConfig config(Map<String, Object> prettierConfig) {
            this.prettierConfig = new TreeMap<String, Object>(prettierConfig);
            this.replaceStep();
            return this;
        }

        @Override
        protected FormatterStep createStep() {
            Project project = FormatExtension.this.getProject();
            return PrettierFormatterStep.create(this.devDependencies, (Provisioner)FormatExtension.this.provisioner(), (File)project.getProjectDir(), (File)((File)project.getLayout().getBuildDirectory().getAsFile().get()), (File)this.npmModulesCacheOrNull(), (NpmPathResolver)new NpmPathResolver(this.npmFileOrNull(), this.nodeFileOrNull(), this.npmrcFileOrNull(), Arrays.asList(project.getProjectDir(), project.getRootDir())), (com.diffplug.spotless.npm.PrettierConfig)new com.diffplug.spotless.npm.PrettierConfig(this.prettierConfigFile != null ? project.file(this.prettierConfigFile) : null, this.prettierConfig));
        }
    }

    public static abstract class NpmStepConfig<T extends NpmStepConfig<?>> {
        public static final String SPOTLESS_NPM_INSTALL_CACHE_DEFAULT_NAME = "spotless-npm-install-cache";
        @Nullable
        protected Object npmFile;
        @Nullable
        protected Object nodeFile;
        @Nullable
        protected Object npmInstallCache;
        @Nullable
        protected Object npmrcFile;
        protected Project project;
        private Consumer<FormatterStep> replaceStep;

        public NpmStepConfig(Project project, Consumer<FormatterStep> replaceStep) {
            this.project = Objects.requireNonNull(project);
            this.replaceStep = Objects.requireNonNull(replaceStep);
        }

        public T npmExecutable(Object npmFile) {
            this.npmFile = npmFile;
            this.replaceStep();
            return (T)this;
        }

        public T nodeExecutable(Object nodeFile) {
            this.nodeFile = nodeFile;
            this.replaceStep();
            return (T)this;
        }

        public T npmrc(Object npmrcFile) {
            this.npmrcFile = npmrcFile;
            this.replaceStep();
            return (T)this;
        }

        public T npmInstallCache(Object npmInstallCache) {
            this.npmInstallCache = npmInstallCache;
            this.replaceStep();
            return (T)this;
        }

        public T npmInstallCache() {
            this.npmInstallCache = new File((File)this.project.getLayout().getBuildDirectory().getAsFile().get(), SPOTLESS_NPM_INSTALL_CACHE_DEFAULT_NAME);
            this.replaceStep();
            return (T)this;
        }

        File npmFileOrNull() {
            return this.fileOrNull(this.npmFile);
        }

        File nodeFileOrNull() {
            return this.fileOrNull(this.nodeFile);
        }

        File npmrcFileOrNull() {
            return this.fileOrNull(this.npmrcFile);
        }

        File npmModulesCacheOrNull() {
            return this.fileOrNull(this.npmInstallCache);
        }

        private File fileOrNull(Object npmFile) {
            return npmFile != null ? this.project.file(npmFile) : null;
        }

        protected void replaceStep() {
            this.replaceStep.accept(this.createStep());
        }

        protected abstract FormatterStep createStep();
    }

    public class LicenseHeaderConfig {
        LicenseHeaderStep builder;
        Boolean updateYearWithLatest = null;

        public LicenseHeaderConfig named(String name) {
            String existingStepName = this.builder.getName();
            this.builder = this.builder.withName(name);
            int existingStepIdx = FormatExtension.this.getExistingStepIdx(existingStepName);
            if (existingStepIdx != -1) {
                FormatExtension.this.steps.set(existingStepIdx, this.createStep());
            } else {
                FormatExtension.this.addStep(this.createStep());
            }
            return this;
        }

        public LicenseHeaderConfig onlyIfContentMatches(String contentPattern) {
            this.builder = this.builder.withContentPattern(contentPattern);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig(LicenseHeaderStep builder) {
            this.builder = builder;
        }

        public LicenseHeaderConfig delimiter(String delimiter) {
            this.builder = this.builder.withDelimiter(delimiter);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig yearSeparator(String yearSeparator) {
            this.builder = this.builder.withYearSeparator(yearSeparator);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig skipLinesMatching(String skipLinesMatching) {
            this.builder = this.builder.withSkipLinesMatching(skipLinesMatching);
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        public LicenseHeaderConfig updateYearWithLatest(boolean updateYearWithLatest) {
            this.updateYearWithLatest = updateYearWithLatest;
            FormatExtension.this.replaceStep(this.createStep());
            return this;
        }

        FormatterStep createStep() {
            return this.builder.withYearModeLazy(() -> {
                if ("true".equals(FormatExtension.this.spotless.project.findProperty(LicenseHeaderStep.FLAG_SET_LICENSE_HEADER_YEARS_FROM_GIT_HISTORY()))) {
                    return LicenseHeaderStep.YearMode.SET_FROM_GIT;
                }
                boolean updateYear = this.updateYearWithLatest == null ? FormatExtension.this.getRatchetFrom() != null : this.updateYearWithLatest;
                return updateYear ? LicenseHeaderStep.YearMode.UPDATE_TO_TODAY : LicenseHeaderStep.YearMode.PRESERVE;
            }).build();
        }
    }

    static class ClosureFormatterFunc
    implements FormatterFunc,
    Serializable {
        private final Closure<String> closure;

        ClosureFormatterFunc(Closure<String> closure) {
            this.closure = closure;
        }

        public String apply(String unixNewlines) {
            return (String)this.closure.call((Object)unixNewlines);
        }
    }

    static class NeverUpToDateBetweenRuns
    extends LazyForwardingEquality<Integer> {
        private static final long serialVersionUID = 1L;
        private static final Random RANDOM = new Random();

        NeverUpToDateBetweenRuns() {
        }

        protected Integer calculateState() throws Exception {
            return RANDOM.nextInt();
        }
    }
}

