/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.JvmLang;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.java.EclipseJdtFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.CleanthatJavaStep;
import com.diffplug.spotless.java.FormatAnnotationsStep;
import com.diffplug.spotless.java.GoogleJavaFormatStep;
import com.diffplug.spotless.java.ImportOrderStep;
import com.diffplug.spotless.java.PalantirJavaFormatStep;
import com.diffplug.spotless.java.RemoveUnusedImportsStep;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;

public class JavaExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense,
JvmLang {
    static final String NAME = "java";
    static final String LICENSE_HEADER_DELIMITER = "(package|import|public|class|module) ";

    @Inject
    public JavaExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, LICENSE_HEADER_DELIMITER);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, LICENSE_HEADER_DELIMITER);
    }

    public ImportOrderConfig importOrder(String ... importOrder) {
        return new ImportOrderConfig(importOrder);
    }

    public ImportOrderConfig importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        return new ImportOrderConfig(this.getProject().file(importOrderFile));
    }

    public void removeUnusedImports() {
        this.addStep(RemoveUnusedImportsStep.create((String)RemoveUnusedImportsStep.defaultFormatter(), (Provisioner)this.provisioner()));
    }

    public void removeUnusedImports(String formatter) {
        this.addStep(RemoveUnusedImportsStep.create((String)formatter, (Provisioner)this.provisioner()));
    }

    public GoogleJavaFormatConfig googleJavaFormat() {
        return this.googleJavaFormat(GoogleJavaFormatStep.defaultVersion());
    }

    public GoogleJavaFormatConfig googleJavaFormat(String version) {
        Objects.requireNonNull(version);
        return new GoogleJavaFormatConfig(version);
    }

    public PalantirJavaFormatConfig palantirJavaFormat() {
        return this.palantirJavaFormat(PalantirJavaFormatStep.defaultVersion());
    }

    public PalantirJavaFormatConfig palantirJavaFormat(String version) {
        Objects.requireNonNull(version);
        return new PalantirJavaFormatConfig(version);
    }

    public EclipseConfig eclipse() {
        return this.eclipse(EclipseJdtFormatterStep.defaultVersion());
    }

    public EclipseConfig eclipse(String version) {
        return new EclipseConfig(version);
    }

    public FormatAnnotationsConfig formatAnnotations() {
        return new FormatAnnotationsConfig();
    }

    public CleanthatJavaConfig cleanthat() {
        return new CleanthatJavaConfig();
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.getSources(this.getProject(), "You must either specify 'target' manually or apply the 'java' plugin.", SourceSet::getAllJava, (Spec<? super File>)((Spec)file -> file.getName().endsWith(".java")));
        }
        this.steps.replaceAll(step -> {
            if (this.isLicenseHeaderStep((FormatterStep)step)) {
                return step.filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
            }
            return step;
        });
        super.setupTask(task);
    }

    public class CleanthatJavaConfig {
        private String groupArtifact = CleanthatJavaStep.defaultGroupArtifact();
        private String version = CleanthatJavaStep.defaultVersion();
        private String sourceJdk = CleanthatJavaStep.defaultSourceJdk();
        private List<String> mutators = new ArrayList<String>(CleanthatJavaStep.defaultMutators());
        private List<String> excludedMutators = new ArrayList<String>(CleanthatJavaStep.defaultExcludedMutators());
        private boolean includeDraft = CleanthatJavaStep.defaultIncludeDraft();

        CleanthatJavaConfig() {
            JavaExtension.this.addStep(this.createStep());
        }

        public CleanthatJavaConfig groupArtifact(String groupArtifact) {
            Objects.requireNonNull(groupArtifact);
            this.groupArtifact = groupArtifact;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig version(String version) {
            Objects.requireNonNull(version);
            this.version = version;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig sourceCompatibility(String jdkVersion) {
            Objects.requireNonNull(jdkVersion);
            this.sourceJdk = jdkVersion;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig clearMutators() {
            this.mutators.clear();
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig addMutator(String mutator) {
            this.mutators.add(mutator);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig addMutators(Collection<String> mutators) {
            this.mutators.addAll(mutators);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig excludeMutator(String mutator) {
            this.excludedMutators.add(mutator);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public CleanthatJavaConfig includeDraft(boolean includeDraft) {
            this.includeDraft = includeDraft;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return CleanthatJavaStep.create((String)this.groupArtifact, (String)this.version, (String)this.sourceJdk, this.mutators, this.excludedMutators, (boolean)this.includeDraft, (Provisioner)JavaExtension.this.provisioner());
        }
    }

    public class FormatAnnotationsConfig {
        final List<String> addedTypeAnnotations = new ArrayList<String>();
        final List<String> removedTypeAnnotations = new ArrayList<String>();

        FormatAnnotationsConfig() {
            JavaExtension.this.addStep(this.createStep());
        }

        public FormatAnnotationsConfig addTypeAnnotation(String simpleName) {
            Objects.requireNonNull(simpleName);
            this.addedTypeAnnotations.add(simpleName);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public FormatAnnotationsConfig removeTypeAnnotation(String simpleName) {
            Objects.requireNonNull(simpleName);
            this.removedTypeAnnotations.add(simpleName);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return FormatAnnotationsStep.create(this.addedTypeAnnotations, this.removedTypeAnnotations);
        }
    }

    public class EclipseConfig {
        private final EclipseJdtFormatterStep.Builder builder;

        EclipseConfig(String version) {
            this.builder = EclipseJdtFormatterStep.createBuilder((Provisioner)JavaExtension.this.provisioner());
            this.builder.setVersion(version);
            JavaExtension.this.addStep(this.builder.build());
        }

        public EclipseConfig configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = JavaExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig configProperties(String ... configs) {
            PluginGradlePreconditions.requireElementsNonNull(configs);
            this.builder.setPropertyPreferences(List.of(configs));
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig sortMembersDoNotSortFields(boolean doNotSortFields) {
            this.builder.sortMembersDoNotSortFields(doNotSortFields);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig sortMembersEnabled(boolean enabled) {
            this.builder.sortMembersEnabled(enabled);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig sortMembersOrder(String order) {
            PluginGradlePreconditions.requireElementsNonNull(new String[]{order});
            this.builder.sortMembersOrder(order);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig sortMembersVisibilityOrder(String order) {
            PluginGradlePreconditions.requireElementsNonNull(new String[]{order});
            this.builder.sortMembersVisibilityOrder(order);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig sortMembersVisibilityOrderEnabled(boolean enabled) {
            this.builder.sortMembersVisibilityOrderEnabled(enabled);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }

        public EclipseConfig withP2Mirrors(Map<String, String> mirrors) {
            this.builder.setP2Mirrors(mirrors);
            JavaExtension.this.replaceStep(this.builder.build());
            return this;
        }
    }

    public class PalantirJavaFormatConfig {
        final String version;
        String style;
        boolean formatJavadoc;

        PalantirJavaFormatConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = PalantirJavaFormatStep.defaultStyle();
            JavaExtension.this.addStep(this.createStep());
        }

        public PalantirJavaFormatConfig style(String style) {
            this.style = Objects.requireNonNull(style);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public PalantirJavaFormatConfig formatJavadoc(boolean formatJavadoc) {
            this.formatJavadoc = formatJavadoc;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return PalantirJavaFormatStep.create((String)this.version, (String)this.style, (boolean)this.formatJavadoc, (Provisioner)JavaExtension.this.provisioner());
        }
    }

    public class GoogleJavaFormatConfig {
        final String version;
        String groupArtifact;
        String style;
        boolean reflowLongStrings;
        boolean reorderImports;
        boolean formatJavadoc = true;

        GoogleJavaFormatConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.groupArtifact = GoogleJavaFormatStep.defaultGroupArtifact();
            this.style = GoogleJavaFormatStep.defaultStyle();
            JavaExtension.this.addStep(this.createStep());
        }

        public GoogleJavaFormatConfig groupArtifact(String groupArtifact) {
            this.groupArtifact = Objects.requireNonNull(groupArtifact);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GoogleJavaFormatConfig style(String style) {
            this.style = Objects.requireNonNull(style);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GoogleJavaFormatConfig aosp() {
            return this.style("AOSP");
        }

        public GoogleJavaFormatConfig reflowLongStrings() {
            return this.reflowLongStrings(true);
        }

        public GoogleJavaFormatConfig reflowLongStrings(boolean reflowLongStrings) {
            this.reflowLongStrings = reflowLongStrings;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GoogleJavaFormatConfig reorderImports(boolean reorderImports) {
            this.reorderImports = reorderImports;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GoogleJavaFormatConfig skipJavadocFormatting() {
            return this.formatJavadoc(false);
        }

        public GoogleJavaFormatConfig formatJavadoc(boolean formatJavadoc) {
            this.formatJavadoc = formatJavadoc;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return GoogleJavaFormatStep.create((String)this.groupArtifact, (String)this.version, (String)this.style, (Provisioner)JavaExtension.this.provisioner(), (boolean)this.reflowLongStrings, (boolean)this.reorderImports, (boolean)this.formatJavadoc);
        }
    }

    public class ImportOrderConfig {
        final String[] importOrder;
        final File importOrderFile;
        boolean wildcardsLast = false;
        boolean semanticSort = false;
        Set<String> treatAsPackage = Set.of();
        Set<String> treatAsClass = Set.of();

        ImportOrderConfig(String[] importOrder) {
            this.importOrder = importOrder;
            this.importOrderFile = null;
            JavaExtension.this.addStep(this.createStep());
        }

        ImportOrderConfig(File importOrderFile) {
            this.importOrder = null;
            this.importOrderFile = importOrderFile;
            JavaExtension.this.addStep(this.createStep());
        }

        public ImportOrderConfig wildcardsLast() {
            return this.wildcardsLast(true);
        }

        public ImportOrderConfig wildcardsLast(boolean wildcardsLast) {
            this.wildcardsLast = wildcardsLast;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ImportOrderConfig semanticSort() {
            return this.semanticSort(true);
        }

        public ImportOrderConfig semanticSort(boolean semanticSort) {
            this.semanticSort = semanticSort;
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ImportOrderConfig treatAsPackage(String ... treatAsPackage) {
            return this.treatAsPackage(Arrays.asList(treatAsPackage));
        }

        public ImportOrderConfig treatAsPackage(Collection<String> treatAsPackage) {
            this.treatAsPackage = new HashSet<String>(treatAsPackage);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ImportOrderConfig treatAsClass(String ... treatAsClass) {
            return this.treatAsClass(Arrays.asList(treatAsClass));
        }

        public ImportOrderConfig treatAsClass(Collection<String> treatAsClass) {
            this.treatAsClass = new HashSet<String>(treatAsClass);
            JavaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            ImportOrderStep importOrderStep = ImportOrderStep.forJava();
            return this.importOrderFile != null ? importOrderStep.createFrom(this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass, JavaExtension.this.getProject().file((Object)this.importOrderFile)) : importOrderStep.createFrom(this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass, this.importOrder);
        }
    }
}

