/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.digitalascent.errorprone.flogger.migrate.FixCollectingTreeScanner;
import com.digitalascent.errorprone.flogger.migrate.LoggerInvocationTreeScanner;
import com.digitalascent.errorprone.flogger.migrate.LoggingConditional;
import com.digitalascent.errorprone.flogger.migrate.MigrationContextFactory;
import com.digitalascent.errorprone.flogger.migrate.RefactoringConfigurationLoader;
import com.digitalascent.errorprone.flogger.migrate.SkipCompilationUnitException;
import com.digitalascent.errorprone.flogger.migrate.SkipLogMethodException;
import com.digitalascent.errorprone.flogger.migrate.SuggestedFixes;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.RefactoringConfiguration;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.target.FloggerSuggestedFixGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.FluentLogger;
import com.google.common.io.Resources;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.LogManager;

@BugPattern(name="LoggerApiRefactoring", summary="Refactor logging API", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Refactoring"})
public final class LoggerApiRefactoringCheck
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final long serialVersionUID = 42L;
    private final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String CONFIGURATION_NAMESPACE = "LoggerApiRefactoring";
    private static final String SOURCE_API_FLAG = String.format("%s:%s", "LoggerApiRefactoring", "SourceApi");
    private final RefactoringConfiguration refactoringConfiguration;
    private final LoggingApiSpecification loggingApiSpecification;
    private final FloggerSuggestedFixGenerator floggerSuggestedFixGenerator;
    private final MigrationContextFactory migrationContextFactory;

    public LoggerApiRefactoringCheck() {
        this.refactoringConfiguration = null;
        this.loggingApiSpecification = null;
        this.floggerSuggestedFixGenerator = null;
        this.migrationContextFactory = null;
    }

    public LoggerApiRefactoringCheck(ErrorProneFlags flags) {
        this.configureLogging();
        ((FluentLogger.Api)this.logger.atInfo()).log("Starting LoggerApiRefactoringCheck with flags: %s", (Object)flags.getFlagsMap());
        String sourceApi = (String)flags.get(SOURCE_API_FLAG).orElseThrow(() -> new IllegalArgumentException("Missing source api for option " + SOURCE_API_FLAG));
        this.refactoringConfiguration = new RefactoringConfigurationLoader().loadRefactoringConfiguration("", sourceApi);
        this.loggingApiSpecification = this.refactoringConfiguration.loggingApiSpecification();
        this.floggerSuggestedFixGenerator = this.refactoringConfiguration.floggerSuggestedFixGenerator();
        this.migrationContextFactory = new MigrationContextFactory(this.loggingApiSpecification, this.refactoringConfiguration.loggerVariableDefinition());
    }

    private void configureLogging() {
        URL url = Resources.getResource(((Object)((Object)this)).getClass(), (String)"logging.properties");
        try (InputStream inputStream = Resources.asByteSource((URL)url).openStream();){
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Description matchCompilationUnit(CompilationUnitTree compilationUnitTree, VisitorState state) {
        List suggestedFixes = (List)compilationUnitTree.getTypeDecls().stream().filter(ClassTree.class::isInstance).map(ClassTree.class::cast).map(classTree -> this.processClassTree((ClassTree)classTree, state)).flatMap(Collection::stream).filter(fix -> !fix.isEmpty()).collect(ImmutableList.toImmutableList());
        if (suggestedFixes.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>(suggestedFixes);
        fixes.addAll(this.processImports(compilationUnitTree, state));
        return this.describeMatch(compilationUnitTree, (Fix)SuggestedFixes.merge(fixes));
    }

    private List<SuggestedFix> processClassTree(ClassTree classTree, VisitorState state) {
        ((FluentLogger.Api)this.logger.atInfo()).log("Processing %s", (Object)classTree.getSimpleName());
        MigrationContext migrationContext = this.migrationContextFactory.createMigrationContext(classTree, state);
        try {
            ((FluentLogger.Api)this.logger.atFine()).log("Migration context: %s", (Object)migrationContext);
            ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>(this.processMethodInvocations(classTree, state, migrationContext));
            if (!fixes.stream().allMatch(SuggestedFix::isEmpty)) {
                fixes.add(this.floggerSuggestedFixGenerator.processLoggerVariables(classTree, state, migrationContext));
            }
            ((FluentLogger.Api)this.logger.atInfo()).log("Processed %s", (Object)classTree.getSimpleName());
            return fixes;
        }
        catch (SkipCompilationUnitException e) {
            ((FluentLogger.Api)this.logger.atWarning()).log("Skipped %s: %s", (Object)migrationContext.className(), (Object)e.getMessage());
            return ImmutableList.of();
        }
    }

    private List<SuggestedFix> processImports(CompilationUnitTree compilationUnitTree, VisitorState state) {
        return this.scanTree(compilationUnitTree, state, new FixCollectingTreeScanner(){

            @Override
            public Void visitImport(ImportTree importTree, VisitorState state) {
                this.addSuggestedFix(LoggerApiRefactoringCheck.this.migrateImport(importTree, state));
                return (Void)super.visitImport(importTree, state);
            }
        });
    }

    private SuggestedFix migrateImport(ImportTree importTree, VisitorState visitorState) {
        if (this.loggingApiSpecification.matchImport(importTree.getQualifiedIdentifier(), visitorState)) {
            return this.floggerSuggestedFixGenerator.removeImport(importTree);
        }
        if (this.loggingApiSpecification.shouldRemoveImport(importTree.getQualifiedIdentifier().toString())) {
            return this.floggerSuggestedFixGenerator.removeImport(importTree);
        }
        return SuggestedFix.builder().build();
    }

    private List<SuggestedFix> scanTree(Tree tree, VisitorState visitorState, FixCollectingTreeScanner treeScanner) {
        tree.accept(treeScanner, visitorState);
        return treeScanner.suggestedFixes();
    }

    private List<SuggestedFix> processMethodInvocations(ClassTree classTree, VisitorState state, MigrationContext migrationContext) {
        LoggerInvocationTreeScanner treeScanner = new LoggerInvocationTreeScanner(migrationContext, this.loggingApiSpecification);
        treeScanner.scan((Tree)classTree, state);
        ArrayList<SuggestedFix> suggestedFixes = new ArrayList<SuggestedFix>(100);
        suggestedFixes.addAll((Collection<SuggestedFix>)this.migrateLoggingConditionals(migrationContext, treeScanner.loggingConditionals()));
        suggestedFixes.addAll((Collection<SuggestedFix>)this.migrateLoggingMethodInvocations(migrationContext, treeScanner.loggingMethodInvocations()));
        suggestedFixes.addAll(this.migrateLoggingConditionalMethods(migrationContext, treeScanner.loggingConditionalMethods()));
        return suggestedFixes;
    }

    private List<SuggestedFix> migrateLoggingConditionalMethods(MigrationContext migrationContext, List<MethodInvocation> conditionalMethods) {
        return (List)conditionalMethods.stream().map(conditionalMethod -> {
            try {
                FloggerConditionalStatement floggerConditionalStatement = this.loggingApiSpecification.parseConditionalMethod((MethodInvocation)conditionalMethod);
                return this.floggerSuggestedFixGenerator.generateConditionalMethod(floggerConditionalStatement, migrationContext);
            }
            catch (SkipLogMethodException e) {
                ((FluentLogger.Api)this.logger.atWarning()).log("Skipped %s %s: %s", (Object)migrationContext.className(), conditionalMethod, (Object)e.getMessage());
                return SuggestedFix.builder().build();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<SuggestedFix> migrateLoggingConditionals(MigrationContext migrationContext, List<LoggingConditional> loggingConditionals) {
        return (ImmutableList)loggingConditionals.stream().map(loggingConditional -> {
            try {
                return this.migrateLoggingConditionals((LoggingConditional)loggingConditional, migrationContext);
            }
            catch (SkipLogMethodException e) {
                ((FluentLogger.Api)this.logger.atWarning()).log("Skipped %s %s: %s", (Object)migrationContext.className(), (Object)loggingConditional.loggingConditionalInvocation(), (Object)e.getMessage());
                return SuggestedFix.builder().build();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<SuggestedFix> migrateLoggingMethodInvocations(MigrationContext migrationContext, List<MethodInvocation> loggingMethodInvocations) {
        return (ImmutableList)loggingMethodInvocations.stream().map(loggingMethodInvocation -> {
            try {
                return this.migrateLoggingMethodInvocation((MethodInvocation)loggingMethodInvocation, migrationContext);
            }
            catch (SkipLogMethodException e) {
                ((FluentLogger.Api)this.logger.atWarning()).log("Skipped %s %s: %s", (Object)migrationContext.className(), loggingMethodInvocation, (Object)e.getMessage());
                return SuggestedFix.builder().build();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private SuggestedFix migrateLoggingMethodInvocation(MethodInvocation loggingMethodInvocation, MigrationContext migrationContext) {
        Preconditions.checkArgument((boolean)this.loggingApiSpecification.matchLoggingMethod(loggingMethodInvocation.tree(), loggingMethodInvocation.state()), (String)"matchLoggingMethod(loggingMethodInvocation, state) : %s", (Object)loggingMethodInvocation);
        FloggerLogStatement floggerLogStatement = this.loggingApiSpecification.parseLoggingMethod(loggingMethodInvocation, migrationContext);
        return this.floggerSuggestedFixGenerator.generateLoggingMethod(loggingMethodInvocation, floggerLogStatement, migrationContext);
    }

    private SuggestedFix migrateLoggingConditionals(LoggingConditional loggingConditional, MigrationContext migrationContext) {
        Preconditions.checkArgument((boolean)this.loggingApiSpecification.matchConditionalMethod(loggingConditional.loggingConditionalInvocation().tree(), loggingConditional.loggingConditionalInvocation().state()), (String)"matchLoggingMethod(loggingConditional.loggingConditionalInvocation(), state) : %s", (Object)loggingConditional);
        switch (loggingConditional.actionType()) {
            case MIGRATE_EXPRESSION_ONLY: {
                FloggerConditionalStatement conditionalStatement = this.loggingApiSpecification.parseConditionalMethod(loggingConditional.loggingConditionalInvocation());
                return this.floggerSuggestedFixGenerator.generateConditionalMethod(conditionalStatement, migrationContext);
            }
            case ELIDE: {
                return this.elideConditional(loggingConditional, migrationContext);
            }
        }
        throw new AssertionError((Object)("Unknown conditional action type: " + (Object)((Object)loggingConditional.actionType())));
    }

    private SuggestedFix elideConditional(LoggingConditional loggingConditional, MigrationContext migrationContext) {
        if (loggingConditional.loggingMethods().isEmpty()) {
            return SuggestedFix.builder().delete((Tree)loggingConditional.ifTree()).build();
        }
        List logStatements = (List)loggingConditional.loggingMethods().stream().map(loggingMethod -> this.loggingApiSpecification.parseLoggingMethod((MethodInvocation)loggingMethod, migrationContext)).collect(ImmutableList.toImmutableList());
        return this.floggerSuggestedFixGenerator.elideConditional(loggingConditional.ifTree(), logStatements, migrationContext, loggingConditional.loggingConditionalInvocation().state());
    }
}

