/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.digitalascent.errorprone.flogger.migrate.LoggingConditional;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class LoggerInvocationTreeScanner
extends TreeScanner<Void, VisitorState> {
    private final MigrationContext migrationContext;
    private final List<MethodInvocation> loggingMethodInvocations = new ArrayList<MethodInvocation>();
    private final List<LoggingConditional> loggingConditionals = new ArrayList<LoggingConditional>();
    private final LoggingApiSpecification loggingApiSpecification;
    private final List<MethodInvocation> loggingConditionalMethods = new ArrayList<MethodInvocation>();

    LoggerInvocationTreeScanner(MigrationContext migrationContext, LoggingApiSpecification loggingApiSpecification) {
        this.migrationContext = Objects.requireNonNull(migrationContext, "migrationContext");
        this.loggingApiSpecification = Objects.requireNonNull(loggingApiSpecification, "loggingApiSpecification");
    }

    List<MethodInvocation> loggingMethodInvocations() {
        return this.loggingMethodInvocations;
    }

    List<LoggingConditional> loggingConditionals() {
        return this.loggingConditionals;
    }

    List<MethodInvocation> loggingConditionalMethods() {
        return this.loggingConditionalMethods;
    }

    @Override
    public Void scan(Tree tree, VisitorState visitorState) {
        Void retVal = (Void)super.scan(tree, visitorState);
        this.resolveUniqueLoggingMethodInvocations();
        this.resolveUniqueLoggingEnabledMethodInvocations();
        return retVal;
    }

    private void resolveUniqueLoggingEnabledMethodInvocations() {
        for (LoggingConditional loggingConditional : this.loggingConditionals) {
            this.loggingConditionalMethods.remove(loggingConditional.loggingConditionalInvocation());
        }
    }

    private void resolveUniqueLoggingMethodInvocations() {
        ArrayList<MethodInvocation> finalList = new ArrayList<MethodInvocation>(this.loggingMethodInvocations);
        this.loggingMethodInvocations.clear();
        for (LoggingConditional loggingConditional : this.loggingConditionals) {
            finalList.removeAll(loggingConditional.loggingMethods());
        }
        this.loggingMethodInvocations.addAll(finalList);
    }

    @Override
    public Void visitIf(IfTree node, VisitorState visitorState) {
        ParenthesizedTree parenTree = (ParenthesizedTree)node.getCondition();
        ExpressionTree expressionTree = parenTree.getExpression();
        if (this.loggingApiSpecification.matchConditionalMethod(expressionTree, visitorState)) {
            this.loggingConditionals.add(this.createLoggingConditional(node, MethodInvocation.from((MethodInvocationTree)expressionTree, visitorState)));
        }
        return (Void)super.visitIf(node, visitorState);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, VisitorState visitorState) {
        if (this.loggingApiSpecification.matchConditionalMethod(node, visitorState) && this.loggingApiSpecification.matchLoggingMethod(node, visitorState)) {
            throw new IllegalStateException("Cannot be a logging method and a logging enabled method: " + node);
        }
        String variableName = null;
        ExpressionTree methodSelect = node.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            variableName = ((JCTree.JCFieldAccess)methodSelect).selected.toString();
        }
        if (!this.isIgnoredLogger(variableName, this.migrationContext)) {
            if (this.loggingApiSpecification.matchLoggingMethod(node, visitorState)) {
                this.loggingMethodInvocations.add(MethodInvocation.from(node, visitorState));
            } else if (this.loggingApiSpecification.matchConditionalMethod(node, visitorState)) {
                this.loggingConditionalMethods.add(MethodInvocation.from(node, visitorState));
            }
        }
        return (Void)super.visitMethodInvocation(node, visitorState);
    }

    private boolean isIgnoredLogger(@Nullable String variableName, MigrationContext migrationContext) {
        return migrationContext.nonClassNamedLoggers().stream().anyMatch(loggerVariable -> loggerVariable.getName().toString().equals(variableName));
    }

    private LoggingConditional createLoggingConditional(IfTree ifTree, MethodInvocation conditionalExpression) {
        if (ifTree.getElseStatement() != null) {
            return LoggingConditional.migrateExpression(ifTree, conditionalExpression);
        }
        StatementTree statementTree = ifTree.getThenStatement();
        if (statementTree instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)statementTree;
            if (blockTree.getStatements().isEmpty()) {
                return LoggingConditional.elide(ifTree, conditionalExpression);
            }
            if (blockTree.getStatements().stream().allMatch(x -> x instanceof ExpressionStatementTree && this.loggingApiSpecification.matchLoggingMethod(((ExpressionStatementTree)x).getExpression(), conditionalExpression.state()))) {
                return LoggingConditional.elide(ifTree, conditionalExpression, (List)blockTree.getStatements().stream().map(x -> ((ExpressionStatementTree)x).getExpression()).map(MethodInvocationTree.class::cast).map(x -> MethodInvocation.from(x, conditionalExpression.state())).collect(ImmutableList.toImmutableList()));
            }
        }
        return LoggingConditional.migrateExpression(ifTree, conditionalExpression);
    }
}

