/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.digitalascent.errorprone.flogger.migrate.LoggingConditionalActionType;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.google.common.collect.ImmutableList;
import com.sun.source.tree.IfTree;
import java.util.List;
import java.util.Objects;

final class LoggingConditional {
    private final IfTree ifTree;
    private final MethodInvocation loggingConditionalInvocation;
    private final LoggingConditionalActionType actionType;
    private final List<MethodInvocation> loggingMethods;

    static LoggingConditional migrateExpression(IfTree ifTree, MethodInvocation loggingConditionalInvocation) {
        return new LoggingConditional(ifTree, loggingConditionalInvocation, LoggingConditionalActionType.MIGRATE_EXPRESSION_ONLY, (List<MethodInvocation>)ImmutableList.of());
    }

    static LoggingConditional elide(IfTree ifTree, MethodInvocation loggingConditionalInvocation) {
        return LoggingConditional.elide(ifTree, loggingConditionalInvocation, (List<MethodInvocation>)ImmutableList.of());
    }

    static LoggingConditional elide(IfTree ifTree, MethodInvocation loggingConditionalInvocation, List<MethodInvocation> loggingMethods) {
        return new LoggingConditional(ifTree, loggingConditionalInvocation, LoggingConditionalActionType.ELIDE, loggingMethods);
    }

    private LoggingConditional(IfTree ifTree, MethodInvocation loggingConditionalInvocation, LoggingConditionalActionType actionType, List<MethodInvocation> loggingMethods) {
        this.ifTree = Objects.requireNonNull(ifTree, "ifTree");
        this.loggingConditionalInvocation = Objects.requireNonNull(loggingConditionalInvocation, "loggingConditionalInvocation");
        this.actionType = Objects.requireNonNull(actionType, "actionType");
        this.loggingMethods = ImmutableList.copyOf(loggingMethods);
    }

    IfTree ifTree() {
        return this.ifTree;
    }

    MethodInvocation loggingConditionalInvocation() {
        return this.loggingConditionalInvocation;
    }

    LoggingConditionalActionType actionType() {
        return this.actionType;
    }

    List<MethodInvocation> loggingMethods() {
        return this.loggingMethods;
    }
}

