/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;

final class MemberVariableScanner
extends TreeScanner<Void, VisitorState> {
    private final List<VariableTree> loggerVariables = new ArrayList<VariableTree>();
    private final Predicate<VariableTree> loggerVariablePredicate;

    MemberVariableScanner(Predicate<VariableTree> loggerVariablePredicate) {
        this.loggerVariablePredicate = Objects.requireNonNull(loggerVariablePredicate, "loggerVariablePredicate");
    }

    @Override
    public Void visitVariable(VariableTree tree, VisitorState visitorState) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null || sym.getKind() != ElementKind.FIELD) {
            return (Void)super.visitVariable(tree, visitorState);
        }
        if (this.loggerVariablePredicate.test(tree)) {
            this.loggerVariables.add(tree);
        }
        return (Void)super.visitVariable(tree, visitorState);
    }

    List<VariableTree> loggerVariables() {
        return ImmutableList.copyOf(this.loggerVariables);
    }
}

