/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.digitalascent.errorprone.flogger.migrate.MemberVariableScanner;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableMigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.LoggerVariableDefinition;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.source.Arguments;
import com.digitalascent.errorprone.flogger.migrate.source.LoggerVariableNamingType;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import java.util.Objects;

final class MigrationContextFactory {
    private final LoggingApiSpecification loggingApiSpecification;
    private final LoggerVariableDefinition loggerVariableDefinition;

    MigrationContextFactory(LoggingApiSpecification loggingApiSpecification, LoggerVariableDefinition loggerVariableDefinition) {
        this.loggingApiSpecification = Objects.requireNonNull(loggingApiSpecification, "loggingApiSpecification");
        this.loggerVariableDefinition = Objects.requireNonNull(loggerVariableDefinition, "loggerVariableDefinition");
    }

    MigrationContext createMigrationContext(ClassTree classTree, VisitorState visitorState) {
        ImmutableMigrationContext.Builder builder = ImmutableMigrationContext.builder();
        builder.addAllClassNamedLoggers(this.findClassNamedLoggers(classTree, visitorState));
        builder.addAllNonClassNamedLoggers(this.findNonClassNamedLoggers(classTree, visitorState));
        builder.addAllFloggerLoggers(this.findFloggerMemberVariables(classTree, visitorState));
        builder.className(classTree.getSimpleName().toString());
        return builder.build();
    }

    private List<VariableTree> findClassNamedLoggers(ClassTree classTree, VisitorState state) {
        MemberVariableScanner scanner = new MemberVariableScanner(tree -> this.determineLoggerVariableNamingType(classTree, (VariableTree)tree, state) == LoggerVariableNamingType.CLASS_NAMED);
        classTree.accept(scanner, state);
        return scanner.loggerVariables();
    }

    private List<VariableTree> findNonClassNamedLoggers(ClassTree classTree, VisitorState state) {
        MemberVariableScanner scanner = new MemberVariableScanner(tree -> this.determineLoggerVariableNamingType(classTree, (VariableTree)tree, state) == LoggerVariableNamingType.NON_CLASS_NAMED);
        classTree.accept(scanner, state);
        return scanner.loggerVariables();
    }

    private LoggerVariableNamingType determineLoggerVariableNamingType(ClassTree classTree, VariableTree variableTree, VisitorState visitorState) {
        if (!this.loggingApiSpecification.matchLogFactory(variableTree, visitorState)) {
            return LoggerVariableNamingType.NOT_LOGGER;
        }
        MethodInvocationTree logManagerMethodInvocationTree = (MethodInvocationTree)variableTree.getInitializer();
        if (logManagerMethodInvocationTree.getArguments().isEmpty() || Arguments.isLoggerNamedAfterClass(classTree, logManagerMethodInvocationTree.getArguments().get(0), visitorState)) {
            return LoggerVariableNamingType.CLASS_NAMED;
        }
        return LoggerVariableNamingType.NON_CLASS_NAMED;
    }

    private List<VariableTree> findFloggerMemberVariables(Tree typeDecl, VisitorState state) {
        Matcher matcher = Matchers.isSubtypeOf((String)this.loggerVariableDefinition.typeQualified());
        MemberVariableScanner scanner = new MemberVariableScanner(tree -> matcher.matches((Tree)tree, state));
        typeDecl.accept(scanner, state);
        return scanner.loggerVariables();
    }
}

