/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate;

import com.digitalascent.errorprone.flogger.migrate.TargetLogLevelMapper;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableLoggerVariableDefinition;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableRefactoringConfiguration;
import com.digitalascent.errorprone.flogger.migrate.model.LoggerVariableDefinition;
import com.digitalascent.errorprone.flogger.migrate.model.RefactoringConfiguration;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.commonslogging.CommonsLoggingLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.commonslogging.CommonsLoggingMessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.jul.JULLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.jul.JULMessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j.Log4JLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j.Log4jMessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j2.Log4j2LoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j2.Log4j2MessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.slf4j.Slf4jLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.slf4j.Slf4jMessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.tinylog.TinyLogLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.tinylog.TinyLogMessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.tinylog2.TinyLog2LoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.tinylog2.TinyLog2MessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatStyle;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.CompositeMessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.LambdaMessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.LazyMessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.Log4j2MessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.MessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.ArraysToStringMessageFormatArgumentReducer;
import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.CompositeMessageFormatArgumentReducer;
import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.MessageFormatArgumentReducer;
import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.ToStringMessageFormatArgumentReducer;
import com.digitalascent.errorprone.flogger.migrate.target.FloggerSuggestedFixGenerator;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

final class RefactoringConfigurationLoader {
    RefactoringConfigurationLoader() {
    }

    RefactoringConfiguration loadRefactoringConfiguration(String userProvidedPropertyPath, String sourceApi) {
        ImmutableRefactoringConfiguration.Builder builder = ImmutableRefactoringConfiguration.builder();
        Properties properties = this.loadProperties(userProvidedPropertyPath);
        LoggerVariableDefinition loggerVariableDefinition = this.readLoggerDefinition(properties);
        builder.loggerVariableDefinition(loggerVariableDefinition);
        FloggerSuggestedFixGenerator floggerSuggestedFixGenerator = new FloggerSuggestedFixGenerator(loggerVariableDefinition);
        builder.floggerSuggestedFixGenerator(floggerSuggestedFixGenerator);
        MessageFormatStyle messageFormatStyle = this.determineMessageFormatStyle(sourceApi, properties);
        Function<String, TargetLogLevel> targetLogLevelFunction = this.readLogLevelMappings(properties);
        Set<String> lazyLogLevels = this.readLazyLogLevels(properties);
        LoggingApiSpecification loggingApiSpecification = this.determineSourceApiConverter(sourceApi, targetLogLevelFunction, messageFormatStyle, lazyLogLevels);
        builder.loggingApiSpecification(loggingApiSpecification);
        return builder.build();
    }

    @Nullable
    private MessageFormatStyle determineMessageFormatStyle(String sourceApi, Properties properties) {
        if ("log4j2".equals(sourceApi)) {
            String log4j2DefaultMessageFormat;
            switch (log4j2DefaultMessageFormat = properties.getProperty("log4j2.default-message-format")) {
                case "brace": {
                    return MessageFormatStyle.LOG4J2_BRACE;
                }
                case "printf": {
                    return MessageFormatStyle.PRINTF;
                }
            }
            throw new AssertionError((Object)("Unknown Log4J2 message format: " + log4j2DefaultMessageFormat));
        }
        return null;
    }

    private Function<String, TargetLogLevel> readLogLevelMappings(Properties properties) {
        Map propMap = (Map)properties.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        Map logLevelMap = (Map)propMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("level.") && ((String)e.getKey()).endsWith(".mapping")).collect(ImmutableMap.toImmutableMap(e -> ((String)e.getKey()).replace("level.", "").replace(".mapping", ""), e -> new TargetLogLevel((String)e.getValue())));
        return new TargetLogLevelMapper(logLevelMap);
    }

    private Set<String> readLazyLogLevels(Properties properties) {
        String lazyLevelsStr = properties.getProperty("lazy.levels", "");
        return ImmutableSet.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)",\t ")).omitEmptyStrings().trimResults().split((CharSequence)lazyLevelsStr));
    }

    private LoggerVariableDefinition readLoggerDefinition(Properties properties) {
        ImmutableLoggerVariableDefinition.Builder builder = ImmutableLoggerVariableDefinition.builder();
        builder.name(properties.getProperty("logger.name"));
        builder.scope(properties.getProperty("logger.scope"));
        builder.modifiers(properties.getProperty("logger.modifiers"));
        builder.typeQualified(properties.getProperty("logger.type"));
        builder.type(properties.getProperty("logger.type.short"));
        builder.factoryMethod(properties.getProperty("logger.factory-method"));
        return builder.build();
    }

    private Properties loadProperties(String userProvidedPropertyPath) {
        URL url = Resources.getResource(this.getClass(), (String)"logger-api-refactoring.properties");
        Properties baseProperties = this.load(Resources.asByteSource((URL)url));
        Properties userProperties = new Properties();
        if (!Strings.isNullOrEmpty((String)userProvidedPropertyPath)) {
            userProperties = this.load(Files.asByteSource((File)new File(userProvidedPropertyPath)));
        }
        Properties finalProperties = new Properties();
        finalProperties.putAll((Map<?, ?>)baseProperties);
        finalProperties.putAll((Map<?, ?>)userProperties);
        return finalProperties;
    }

    private LoggingApiSpecification determineSourceApiConverter(String sourceApi, Function<String, TargetLogLevel> targetLogLevelFunction, @Nullable MessageFormatStyle messageFormatStyle, Set<String> lazyLogLevels) {
        ImmutableMap<String, LoggingApiSpecification> converterMap = this.createLoggingApiSpecifications(targetLogLevelFunction, messageFormatStyle, lazyLogLevels);
        LoggingApiSpecification converter = (LoggingApiSpecification)converterMap.get(sourceApi.toLowerCase().trim());
        if (converter == null) {
            throw new IllegalArgumentException("Unknown source API specified: " + sourceApi);
        }
        return converter;
    }

    private ImmutableMap<String, LoggingApiSpecification> createLoggingApiSpecifications(Function<String, TargetLogLevel> targetLogLevelFunction, @Nullable MessageFormatStyle messageFormatStyle, Set<String> lazyLogLevels) {
        MessageFormatArgumentConverter messageFormatArgumentConverter = this.createMessageFormatArgumentConverter(lazyLogLevels);
        MessageFormatArgumentReducer messageFormatArgumentReducer = this.createMessageFormatArgumentReducer();
        ImmutableMap.Builder converterMapBuilder = ImmutableMap.builder();
        converterMapBuilder.put((Object)"slf4j", (Object)new Slf4jLoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new Slf4jMessageFormatSpecification())));
        converterMapBuilder.put((Object)"log4j", (Object)new Log4JLoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new Log4jMessageFormatSpecification())));
        converterMapBuilder.put((Object)"log4j2", (Object)new Log4j2LoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new Log4j2MessageFormatSpecification(messageFormatStyle))));
        converterMapBuilder.put((Object)"commons-logging", (Object)new CommonsLoggingLoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new CommonsLoggingMessageFormatSpecification())));
        converterMapBuilder.put((Object)"tinylog", (Object)new TinyLogLoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new TinyLogMessageFormatSpecification())));
        converterMapBuilder.put((Object)"tinylog2", (Object)new TinyLog2LoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new TinyLog2MessageFormatSpecification())));
        converterMapBuilder.put((Object)"jul", (Object)new JULLoggingApiSpecification(targetLogLevelFunction, new LogMessageFactory(messageFormatArgumentConverter, messageFormatArgumentReducer, new JULMessageFormatSpecification())));
        return converterMapBuilder.build();
    }

    private MessageFormatArgumentReducer createMessageFormatArgumentReducer() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new ToStringMessageFormatArgumentReducer());
        builder.add((Object)new ArraysToStringMessageFormatArgumentReducer());
        return new CompositeMessageFormatArgumentReducer((List<MessageFormatArgumentReducer>)builder.build());
    }

    private MessageFormatArgumentConverter createMessageFormatArgumentConverter(Set<String> lazyLogLevels) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new LambdaMessageFormatArgumentConverter());
        builder.add((Object)new Log4j2MessageFormatArgumentConverter());
        builder.add((Object)new LazyMessageFormatArgumentConverter(targetLogLevel -> lazyLogLevels.contains(targetLogLevel.methodName())));
        return new CompositeMessageFormatArgumentConverter((List<MessageFormatArgumentConverter>)builder.build());
    }

    private Properties load(ByteSource byteSource) {
        Properties props = new Properties();
        try (InputStream inputStream = byteSource.openBufferedStream();){
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }
}

