/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.model;

import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.source.tree.ExpressionTree;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FloggerLogStatement", generator="Immutables")
@Immutable
public final class ImmutableFloggerLogStatement
implements FloggerLogStatement {
    private final LogMessage logMessage;
    private final TargetLogLevel targetLogLevel;
    @Nullable
    private final ExpressionTree thrown;

    private ImmutableFloggerLogStatement(Builder builder) {
        this.logMessage = builder.logMessage;
        this.targetLogLevel = builder.targetLogLevel;
        this.thrown = builder.thrown;
    }

    @Override
    public LogMessage logMessage() {
        return this.logMessage;
    }

    @Override
    public TargetLogLevel targetLogLevel() {
        return this.targetLogLevel;
    }

    @Override
    @Nullable
    public ExpressionTree thrown() {
        return this.thrown;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFloggerLogStatement && this.equalTo((ImmutableFloggerLogStatement)another);
    }

    private boolean equalTo(ImmutableFloggerLogStatement another) {
        return this.logMessage.equals(another.logMessage) && this.targetLogLevel.equals(another.targetLogLevel) && Objects.equals(this.thrown, another.thrown);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.logMessage.hashCode();
        h += (h << 5) + this.targetLogLevel.hashCode();
        h += (h << 5) + Objects.hashCode(this.thrown);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FloggerLogStatement").omitNullValues().add("logMessage", (Object)this.logMessage).add("targetLogLevel", (Object)this.targetLogLevel).add("thrown", (Object)this.thrown).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FloggerLogStatement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOG_MESSAGE = 1L;
        private static final long INIT_BIT_TARGET_LOG_LEVEL = 2L;
        private static final long OPT_BIT_THROWN = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private LogMessage logMessage;
        @Nullable
        private TargetLogLevel targetLogLevel;
        @Nullable
        private ExpressionTree thrown;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder logMessage(LogMessage logMessage) {
            Builder.checkNotIsSet(this.logMessageIsSet(), "logMessage");
            this.logMessage = Objects.requireNonNull(logMessage, "logMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetLogLevel(TargetLogLevel targetLogLevel) {
            Builder.checkNotIsSet(this.targetLogLevelIsSet(), "targetLogLevel");
            this.targetLogLevel = Objects.requireNonNull(targetLogLevel, "targetLogLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder thrown(@Nullable ExpressionTree thrown) {
            Builder.checkNotIsSet(this.thrownIsSet(), "thrown");
            this.thrown = thrown;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableFloggerLogStatement build() {
            this.checkRequiredAttributes();
            return new ImmutableFloggerLogStatement(this);
        }

        private boolean thrownIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logMessageIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean targetLogLevelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of FloggerLogStatement is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.logMessageIsSet()) {
                attributes.add("logMessage");
            }
            if (!this.targetLogLevelIsSet()) {
                attributes.add("targetLogLevel");
            }
            return "Cannot build FloggerLogStatement, some of required attributes are not set " + attributes;
        }
    }
}

