/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.model;

import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MigrationContext", generator="Immutables")
@Immutable
public final class ImmutableMigrationContext
implements MigrationContext {
    private final ImmutableList<VariableTree> classNamedLoggers;
    private final ImmutableList<VariableTree> nonClassNamedLoggers;
    private final ImmutableList<VariableTree> floggerLoggers;
    private final String className;

    private ImmutableMigrationContext(Builder builder) {
        this.classNamedLoggers = builder.classNamedLoggers.build();
        this.nonClassNamedLoggers = builder.nonClassNamedLoggers.build();
        this.floggerLoggers = builder.floggerLoggers.build();
        this.className = builder.className;
    }

    public ImmutableList<VariableTree> classNamedLoggers() {
        return this.classNamedLoggers;
    }

    public ImmutableList<VariableTree> nonClassNamedLoggers() {
        return this.nonClassNamedLoggers;
    }

    public ImmutableList<VariableTree> floggerLoggers() {
        return this.floggerLoggers;
    }

    @Override
    public String className() {
        return this.className;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMigrationContext && this.equalTo((ImmutableMigrationContext)another);
    }

    private boolean equalTo(ImmutableMigrationContext another) {
        return this.classNamedLoggers.equals(another.classNamedLoggers) && this.nonClassNamedLoggers.equals(another.nonClassNamedLoggers) && this.floggerLoggers.equals(another.floggerLoggers) && this.className.equals(another.className);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classNamedLoggers.hashCode();
        h += (h << 5) + this.nonClassNamedLoggers.hashCode();
        h += (h << 5) + this.floggerLoggers.hashCode();
        h += (h << 5) + this.className.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MigrationContext").omitNullValues().add("classNamedLoggers", this.classNamedLoggers).add("nonClassNamedLoggers", this.nonClassNamedLoggers).add("floggerLoggers", this.floggerLoggers).add("className", (Object)this.className).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MigrationContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private long initBits = 1L;
        private final ImmutableList.Builder<VariableTree> classNamedLoggers = ImmutableList.builder();
        private final ImmutableList.Builder<VariableTree> nonClassNamedLoggers = ImmutableList.builder();
        private final ImmutableList.Builder<VariableTree> floggerLoggers = ImmutableList.builder();
        @Nullable
        private String className;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder addClassNamedLogger(VariableTree element) {
            this.classNamedLoggers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addClassNamedLoggers(VariableTree ... elements) {
            this.classNamedLoggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllClassNamedLoggers(Iterable<? extends VariableTree> elements) {
            this.classNamedLoggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonClassNamedLogger(VariableTree element) {
            this.nonClassNamedLoggers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNonClassNamedLoggers(VariableTree ... elements) {
            this.nonClassNamedLoggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNonClassNamedLoggers(Iterable<? extends VariableTree> elements) {
            this.nonClassNamedLoggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFloggerLogger(VariableTree element) {
            this.floggerLoggers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFloggerLoggers(VariableTree ... elements) {
            this.floggerLoggers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllFloggerLoggers(Iterable<? extends VariableTree> elements) {
            this.floggerLoggers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder className(String className) {
            Builder.checkNotIsSet(this.classNameIsSet(), "className");
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMigrationContext build() {
            this.checkRequiredAttributes();
            return new ImmutableMigrationContext(this);
        }

        private boolean classNameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MigrationContext is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            return "Cannot build MigrationContext, some of required attributes are not set " + attributes;
        }
    }
}

