/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.model;

import com.digitalascent.errorprone.flogger.migrate.model.LoggerVariableDefinition;
import com.digitalascent.errorprone.flogger.migrate.model.RefactoringConfiguration;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.target.FloggerSuggestedFixGenerator;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefactoringConfiguration", generator="Immutables")
@Immutable
public final class ImmutableRefactoringConfiguration
implements RefactoringConfiguration {
    private final LoggingApiSpecification loggingApiSpecification;
    private final FloggerSuggestedFixGenerator floggerSuggestedFixGenerator;
    private final LoggerVariableDefinition loggerVariableDefinition;

    private ImmutableRefactoringConfiguration(Builder builder) {
        this.loggingApiSpecification = builder.loggingApiSpecification;
        this.floggerSuggestedFixGenerator = builder.floggerSuggestedFixGenerator;
        this.loggerVariableDefinition = builder.loggerVariableDefinition;
    }

    @Override
    public LoggingApiSpecification loggingApiSpecification() {
        return this.loggingApiSpecification;
    }

    @Override
    public FloggerSuggestedFixGenerator floggerSuggestedFixGenerator() {
        return this.floggerSuggestedFixGenerator;
    }

    @Override
    public LoggerVariableDefinition loggerVariableDefinition() {
        return this.loggerVariableDefinition;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefactoringConfiguration && this.equalTo((ImmutableRefactoringConfiguration)another);
    }

    private boolean equalTo(ImmutableRefactoringConfiguration another) {
        return this.loggingApiSpecification.equals(another.loggingApiSpecification) && this.floggerSuggestedFixGenerator.equals(another.floggerSuggestedFixGenerator) && this.loggerVariableDefinition.equals(another.loggerVariableDefinition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.loggingApiSpecification.hashCode();
        h += (h << 5) + this.floggerSuggestedFixGenerator.hashCode();
        h += (h << 5) + this.loggerVariableDefinition.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefactoringConfiguration").omitNullValues().add("loggingApiSpecification", (Object)this.loggingApiSpecification).add("floggerSuggestedFixGenerator", (Object)this.floggerSuggestedFixGenerator).add("loggerVariableDefinition", (Object)this.loggerVariableDefinition).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefactoringConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOGGING_API_SPECIFICATION = 1L;
        private static final long INIT_BIT_FLOGGER_SUGGESTED_FIX_GENERATOR = 2L;
        private static final long INIT_BIT_LOGGER_VARIABLE_DEFINITION = 4L;
        private long initBits = 7L;
        @Nullable
        private LoggingApiSpecification loggingApiSpecification;
        @Nullable
        private FloggerSuggestedFixGenerator floggerSuggestedFixGenerator;
        @Nullable
        private LoggerVariableDefinition loggerVariableDefinition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder loggingApiSpecification(LoggingApiSpecification loggingApiSpecification) {
            Builder.checkNotIsSet(this.loggingApiSpecificationIsSet(), "loggingApiSpecification");
            this.loggingApiSpecification = Objects.requireNonNull(loggingApiSpecification, "loggingApiSpecification");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder floggerSuggestedFixGenerator(FloggerSuggestedFixGenerator floggerSuggestedFixGenerator) {
            Builder.checkNotIsSet(this.floggerSuggestedFixGeneratorIsSet(), "floggerSuggestedFixGenerator");
            this.floggerSuggestedFixGenerator = Objects.requireNonNull(floggerSuggestedFixGenerator, "floggerSuggestedFixGenerator");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loggerVariableDefinition(LoggerVariableDefinition loggerVariableDefinition) {
            Builder.checkNotIsSet(this.loggerVariableDefinitionIsSet(), "loggerVariableDefinition");
            this.loggerVariableDefinition = Objects.requireNonNull(loggerVariableDefinition, "loggerVariableDefinition");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRefactoringConfiguration build() {
            this.checkRequiredAttributes();
            return new ImmutableRefactoringConfiguration(this);
        }

        private boolean loggingApiSpecificationIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean floggerSuggestedFixGeneratorIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean loggerVariableDefinitionIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RefactoringConfiguration is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.loggingApiSpecificationIsSet()) {
                attributes.add("loggingApiSpecification");
            }
            if (!this.floggerSuggestedFixGeneratorIsSet()) {
                attributes.add("floggerSuggestedFixGenerator");
            }
            if (!this.loggerVariableDefinitionIsSet()) {
                attributes.add("loggerVariableDefinition");
            }
            return "Cannot build RefactoringConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

