/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Objects;

public final class MethodInvocation {
    private final MethodInvocationTree tree;
    private final String methodName;
    private final VisitorState state;

    public static MethodInvocation from(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (sym == null) {
            throw new IllegalArgumentException("Invalid tree: " + tree);
        }
        String methodName = ((Name)sym.getSimpleName()).toString();
        return new MethodInvocation(tree, methodName, state);
    }

    private MethodInvocation(MethodInvocationTree tree, String methodName, VisitorState state) {
        this.tree = Objects.requireNonNull(tree, "tree");
        this.methodName = Objects.requireNonNull(methodName, "methodName");
        this.state = Objects.requireNonNull(state, "state");
    }

    public MethodInvocationTree tree() {
        return this.tree;
    }

    public String methodName() {
        return this.methodName;
    }

    public VisitorState state() {
        return this.state;
    }

    public ExpressionTree firstArgument() {
        return this.tree.getArguments().get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInvocation that = (MethodInvocation)o;
        return com.google.common.base.Objects.equal((Object)this.tree, (Object)that.tree);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tree});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tree", (Object)this.tree).toString();
    }
}

