/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source;

import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.source.Arguments;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ArgumentParser {
    private static final Matcher<ExpressionTree> THROWABLE_MATCHER = Matchers.isSubtypeOf(Throwable.class);
    private List<? extends ExpressionTree> arguments;
    private final MethodInvocation methodInvocation;

    private ArgumentParser(MethodInvocation methodInvocation) {
        this.methodInvocation = Objects.requireNonNull(methodInvocation, "methodInvocation");
        this.arguments = new ArrayList<ExpressionTree>(methodInvocation.tree().getArguments());
    }

    public static ArgumentParser forArgumentsOf(MethodInvocation methodInvocation) {
        return new ArgumentParser(methodInvocation);
    }

    public void skipIfPresent(Predicate<ExpressionTree> predicate) {
        if (predicate.test(this.currentArgument())) {
            this.nextArgument();
        }
    }

    private void nextArgument() {
        this.arguments = Arguments.removeFirst(this.arguments);
    }

    private ExpressionTree currentArgument() {
        return this.arguments.get(0);
    }

    public ExpressionTree extractIfMatches(Predicate<ExpressionTree> predicate) {
        ExpressionTree expressionTree = this.currentArgument();
        if (predicate.test(expressionTree)) {
            this.nextArgument();
            return expressionTree;
        }
        return null;
    }

    public ExpressionTree extract() {
        return this.extractIfMatches(x -> true);
    }

    public void maybeUnpackVarArgs() {
        this.arguments = Arguments.maybeUnpackVarArgs(this.arguments, this.methodInvocation.state());
    }

    public ExpressionTree trailingThrowable() {
        ExpressionTree throwable = Arguments.matchAtIndex(this.arguments, this.methodInvocation.state(), THROWABLE_MATCHER, this.arguments.size() - 1).orElse(null);
        if (throwable != null) {
            this.removeLast();
        }
        return throwable;
    }

    private void removeLast() {
        this.arguments = Arguments.removeLast(this.arguments);
    }

    public List<? extends ExpressionTree> remainingArguments() {
        return ImmutableList.copyOf(this.arguments);
    }

    public ExpressionTree extractOrElse(@Nullable ExpressionTree expressionTree) {
        if (this.arguments.isEmpty()) {
            return expressionTree;
        }
        ExpressionTree argument = this.currentArgument();
        this.nextArgument();
        return argument;
    }

    public ExpressionTree firstMatching(Predicate<ExpressionTree> expressionTreePredicate) {
        if (this.arguments.isEmpty()) {
            throw new IllegalStateException("Unable to locate argument");
        }
        ExpressionTree expressionTree = this.currentArgument();
        if (expressionTreePredicate.test(expressionTree)) {
            this.nextArgument();
            return expressionTree;
        }
        return this.firstMatching(expressionTreePredicate);
    }

    public void skip(int argumentToSkip) {
        for (int i = 0; i < argumentToSkip; ++i) {
            this.skipIfPresent(argument -> true);
        }
    }

    public boolean isEmpty() {
        return this.arguments.isEmpty();
    }
}

