/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Optional;

public final class Arguments {
    private static final Matcher<ExpressionTree> STRING_MATCHER = Matchers.isSubtypeOf(String.class);

    static List<? extends ExpressionTree> removeLast(List<? extends ExpressionTree> expressions) {
        if (expressions.size() <= 1) {
            return ImmutableList.of();
        }
        return expressions.subList(0, expressions.size() - 1);
    }

    public static List<? extends ExpressionTree> maybeUnpackVarArgs(List<? extends ExpressionTree> arguments, VisitorState state) {
        if (arguments.size() == 1) {
            ExpressionTree argument = arguments.get(0);
            if (Matchers.isArrayType().matches((Tree)argument, state)) {
                JCTree.JCNewArray newArray = (JCTree.JCNewArray)argument;
                return newArray.elems;
            }
        }
        return arguments;
    }

    public static List<? extends ExpressionTree> prependArgument(List<? extends ExpressionTree> arguments, ExpressionTree argument) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.add((Object)argument).addAll(arguments).build();
    }

    public static List<? extends ExpressionTree> removeFirst(List<? extends ExpressionTree> arguments) {
        if (arguments.isEmpty()) {
            return arguments;
        }
        return arguments.subList(1, arguments.size());
    }

    public static Optional<ExpressionTree> matchAtIndex(List<? extends ExpressionTree> expressions, VisitorState state, Matcher<ExpressionTree> expressionTreeMatcher, int index) {
        if (index < 0 || index > expressions.size() - 1) {
            return Optional.empty();
        }
        ExpressionTree candidateArgument = expressions.get(index);
        if (expressionTreeMatcher.matches((Tree)candidateArgument, state)) {
            return Optional.of(candidateArgument);
        }
        return Optional.empty();
    }

    public static boolean isStringType(ExpressionTree expressionTree, VisitorState state) {
        return STRING_MATCHER.matches((Tree)expressionTree, state);
    }

    public static boolean isStringLiteral(ExpressionTree expressionTree, VisitorState state) {
        return expressionTree instanceof LiteralTree && STRING_MATCHER.matches((Tree)expressionTree, state);
    }

    public static boolean isLoggerNamedAfterClass(ClassTree classTree, ExpressionTree argument, VisitorState state) {
        String expectedSimpleClassName = classTree.getSimpleName().toString();
        String expectedQualifiedClassName = ASTHelpers.getSymbol((ClassTree)classTree).fullname.toString();
        if ("getClass()".equals(argument.toString())) {
            return true;
        }
        if (Matchers.staticFieldAccess().matches((Tree)argument, state) && Matchers.isSameType((String)"java.lang.Class").matches((Tree)argument, state) && expectedQualifiedClassName.equals(ASTHelpers.getSymbol((Tree)argument).owner.type.toString())) {
            return true;
        }
        String stringValue = (String)ASTHelpers.constValue((Tree)argument, String.class);
        if (expectedQualifiedClassName.equals(stringValue)) {
            return true;
        }
        if ("getClass().getName()".equals(argument.toString())) {
            return true;
        }
        if (Arguments.isClassGetName(argument, state)) {
            return (expectedSimpleClassName + ".class.getName").equals(((MethodInvocationTree)argument).getMethodSelect().toString());
        }
        return false;
    }

    private static boolean isClassGetName(ExpressionTree argument, VisitorState state) {
        return Matchers.methodInvocation((Matcher)Matchers.instanceMethod().onExactClass("java.lang.Class").named("getName")).matches((Tree)argument, state);
    }

    private Arguments() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }
}

