/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api;

import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.LoggingApiSpecification;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class AbstractLoggingApiSpecification
implements LoggingApiSpecification {
    private final Function<String, TargetLogLevel> targetLogLevelFunction;
    private final LogMessageFactory logMessageFactory;

    protected AbstractLoggingApiSpecification(Function<String, TargetLogLevel> targetLogLevelFunction, LogMessageFactory logMessageFactory) {
        this.targetLogLevelFunction = Objects.requireNonNull(targetLogLevelFunction, "targetLogLevelFunction");
        this.logMessageFactory = Objects.requireNonNull(logMessageFactory, "logMessageFactory");
    }

    protected final TargetLogLevel mapLogLevel(String level) {
        return this.targetLogLevelFunction.apply(level);
    }

    protected final LogMessage createLogMessage(String messageFormat, List<? extends ExpressionTree> arguments, VisitorState state, TargetLogLevel targetLogLevel) {
        return this.logMessageFactory.create(messageFormat, arguments, state, targetLogLevel);
    }

    protected final LogMessage createLogMessage(ExpressionTree messageFormatArgument, List<? extends ExpressionTree> remainingArguments, VisitorState state, @Nullable ExpressionTree thrownArgument, MigrationContext migrationContext, TargetLogLevel targetLogLevel) {
        return this.logMessageFactory.create(messageFormatArgument, remainingArguments, state, thrownArgument, migrationContext, targetLogLevel);
    }
}

