/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api;

import com.digitalascent.errorprone.flogger.migrate.SkipLogMethodException;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.Arguments;
import com.digitalascent.errorprone.flogger.migrate.source.format.EmptyArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatArgument;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionFailedException;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionResult;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatEmptyArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.format.StringConcatenationEmptyArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.StringFormatEmprtArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.MessageFormatArgumentConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.MessageFormatArgumentReducer;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class LogMessageFactory {
    private final MessageFormatArgumentConverter messageFormatArgumentConverter;
    private final MessageFormatArgumentReducer messageFormatArgumentReducer;
    private final MessageFormatSpecification messageFormatSpecification;
    private final List<EmptyArgumentsHandler> emptyArgumentsHandlers;

    public LogMessageFactory(MessageFormatArgumentConverter messageFormatArgumentConverter, MessageFormatArgumentReducer messageFormatArgumentReducer, MessageFormatSpecification messageFormatSpecification) {
        this.messageFormatArgumentConverter = Objects.requireNonNull(messageFormatArgumentConverter, "messageFormatArgumentConverter");
        this.messageFormatArgumentReducer = Objects.requireNonNull(messageFormatArgumentReducer, "messageFormatArgumentReducer");
        this.messageFormatSpecification = Objects.requireNonNull(messageFormatSpecification, "messageFormatSpecification");
        this.emptyArgumentsHandlers = ImmutableList.builder().add((Object)new StringFormatEmprtArgumentsHandler()).add((Object)new MessageFormatEmptyArgumentsHandler()).add((Object)new StringConcatenationEmptyArgumentsHandler()).build();
    }

    final LogMessage create(String messageFormat, List<? extends ExpressionTree> arguments, VisitorState state, TargetLogLevel targetLogLevel) {
        return LogMessage.fromStringFormat(messageFormat, this.processArguments(arguments, state, targetLogLevel), (List<String>)ImmutableList.of());
    }

    final LogMessage create(ExpressionTree messageFormatArgument, List<? extends ExpressionTree> remainingArguments, VisitorState state, @Nullable ExpressionTree thrownArgument, MigrationContext migrationContext, TargetLogLevel targetLogLevel) {
        if (this.messageFormatSpecification.shouldSkipMessageFormatArgument(messageFormatArgument, state)) {
            throw new SkipLogMethodException("Unable to convert message format: " + messageFormatArgument);
        }
        if (thrownArgument == messageFormatArgument) {
            return LogMessage.fromStringFormat("Exception", (List<MessageFormatArgument>)ImmutableList.of());
        }
        if (!Arguments.isStringType(messageFormatArgument, state)) {
            return LogMessage.fromStringFormat("%s", this.processArguments(Arguments.prependArgument(remainingArguments, messageFormatArgument), state, targetLogLevel));
        }
        if (remainingArguments.isEmpty()) {
            Optional<MessageFormatConversionResult> first = this.emptyArgumentsHandlers.stream().map(handler -> {
                try {
                    return handler.handle(messageFormatArgument, state, targetLogLevel);
                }
                catch (MessageFormatConversionFailedException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst();
            return first.map(result -> {
                List<? extends ExpressionTree> arguments = Arguments.maybeUnpackVarArgs(result.arguments(), state);
                return LogMessage.fromStringFormat(result.messageFormat(), this.processArguments(arguments, state, targetLogLevel), result.conversionIssues());
            }).orElse(LogMessage.fromMessageFormatArgument(messageFormatArgument, (List<MessageFormatArgument>)ImmutableList.of()));
        }
        if (Arguments.isStringLiteral(messageFormatArgument, state)) {
            String sourceMessageFormat = (String)((JCTree.JCLiteral)messageFormatArgument).value;
            MessageFormatConversionResult result2 = this.messageFormatSpecification.convertMessageFormat(messageFormatArgument, sourceMessageFormat, remainingArguments, migrationContext);
            return LogMessage.fromStringFormat(result2.messageFormat(), this.processArguments(result2.arguments(), state, targetLogLevel), result2.conversionIssues());
        }
        return LogMessage.unableToConvert(messageFormatArgument, this.processArguments(remainingArguments, state, targetLogLevel));
    }

    private List<MessageFormatArgument> processArguments(List<? extends ExpressionTree> arguments, VisitorState state, TargetLogLevel targetLogLevel) {
        return (List)arguments.stream().map(x -> this.messageFormatArgumentReducer.reduce((ExpressionTree)x, state)).map(x -> this.messageFormatArgumentConverter.convert((ExpressionTree)x, state, targetLogLevel)).collect(ImmutableList.toImmutableList());
    }
}

