/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.commonslogging;

import com.digitalascent.errorprone.flogger.migrate.model.FloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.ArgumentParser;
import com.digitalascent.errorprone.flogger.migrate.source.api.AbstractLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.SourceApiUtil;
import com.digitalascent.errorprone.flogger.migrate.source.api.commonslogging.CommonsLoggingMatchers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.function.Function;

public class CommonsLoggingLoggingApiSpecification
extends AbstractLoggingApiSpecification {
    private static final ImmutableSet<String> LOGGING_PACKAGE_PREFIXES = ImmutableSet.of((Object)"org.apache.commons.logging");

    public CommonsLoggingLoggingApiSpecification(Function<String, TargetLogLevel> targetLogLevelFunction, LogMessageFactory logMessageFactory) {
        super(targetLogLevelFunction, logMessageFactory);
    }

    @Override
    public boolean matchConditionalMethod(ExpressionTree expressionTree, VisitorState state) {
        return CommonsLoggingMatchers.loggingEnabledMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLoggingMethod(ExpressionTree expressionTree, VisitorState state) {
        return CommonsLoggingMatchers.loggingMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLogFactory(VariableTree variableTree, VisitorState visitorState) {
        return CommonsLoggingMatchers.logFactoryMethod().matches((Tree)variableTree.getInitializer(), visitorState);
    }

    @Override
    public boolean matchImport(Tree qualifiedIdentifier, VisitorState visitorState) {
        return CommonsLoggingMatchers.loggerImports().matches(qualifiedIdentifier, visitorState);
    }

    @Override
    public boolean shouldRemoveImport(String importString) {
        return LOGGING_PACKAGE_PREFIXES.stream().anyMatch(importString::startsWith);
    }

    @Override
    public FloggerConditionalStatement parseConditionalMethod(MethodInvocation methodInvocation) {
        ImmutableFloggerConditionalStatement.Builder builder = ImmutableFloggerConditionalStatement.builder();
        String level = SourceApiUtil.logLevelFromMethodName(methodInvocation);
        builder.targetLogLevel(this.mapLogLevel(level));
        builder.conditionalStatement(methodInvocation);
        return builder.build();
    }

    @Override
    public FloggerLogStatement parseLoggingMethod(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        TargetLogLevel targetLogLevel = this.mapLogLevel(methodInvocation.methodName());
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        ArgumentParser argumentParser = ArgumentParser.forArgumentsOf(methodInvocation);
        ExpressionTree throwableArgument = argumentParser.trailingThrowable();
        builder.thrown(throwableArgument);
        ExpressionTree messageFormatArgument = argumentParser.extractOrElse(throwableArgument);
        Verify.verify((messageFormatArgument != null ? 1 : 0) != 0);
        LogMessage logMessage = this.createLogMessage(messageFormatArgument, argumentParser.remainingArguments(), methodInvocation.state(), throwableArgument, migrationContext, targetLogLevel);
        builder.logMessage(logMessage);
        return builder.build();
    }
}

