/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.commonslogging;

import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

final class CommonsLoggingMatchers {
    private static final String LOG_CLASS = "org.apache.commons.logging.Log";
    private static final String LOG_FACTORY_CLASS = "org.apache.commons.logging.LogFactory";
    private static final Matcher<ExpressionTree> IS_ENABLED_METHODS = Matchers.instanceMethod().onDescendantOf("org.apache.commons.logging.Log").namedAnyOf(new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isFatalEnabled"});
    private static final Matcher<ExpressionTree> LOGGING_METHODS = Matchers.instanceMethod().onDescendantOf("org.apache.commons.logging.Log").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error", "fatal"});
    private static final Matcher<ExpressionTree> LOG_FACTORY_MATCHER = Matchers.methodInvocation((Matcher)Matchers.staticMethod().onClass("org.apache.commons.logging.LogFactory").namedAnyOf(new String[]{"getLog"}));
    private static final Matcher<Tree> LOG_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.apache.commons.logging.Log");
    private static final Matcher<Tree> LOGGER_FACTORY_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.apache.commons.logging.LogFactory");
    private static final Matcher<Tree> IMPORT_TYPES = Matchers.anyOf((Matcher[])new Matcher[]{LOG_TYPE_MATCHER, LOGGER_FACTORY_TYPE_MATCHER});

    static Matcher<ExpressionTree> loggingMethod() {
        return LOGGING_METHODS;
    }

    static Matcher<ExpressionTree> loggingEnabledMethod() {
        return IS_ENABLED_METHODS;
    }

    static Matcher<ExpressionTree> logFactoryMethod() {
        return LOG_FACTORY_MATCHER;
    }

    static Matcher<Tree> loggerImports() {
        return IMPORT_TYPES;
    }

    private CommonsLoggingMatchers() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }
}

