/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.jul;

import com.digitalascent.errorprone.flogger.migrate.SkipCompilationUnitException;
import com.digitalascent.errorprone.flogger.migrate.SkipLogMethodException;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.ArgumentParser;
import com.digitalascent.errorprone.flogger.migrate.source.Arguments;
import com.digitalascent.errorprone.flogger.migrate.source.api.AbstractLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.jul.JULMatchers;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatArgument;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class JULLoggingApiSpecification
extends AbstractLoggingApiSpecification {
    private static final ImmutableSet<String> LOGGING_PACKAGE_PREFIXES = ImmutableSet.of((Object)"java.util.logging");
    private static final Set<String> ENTERING_EXITING_METHOD_NAMES = ImmutableSet.of((Object)"entering", (Object)"exiting");

    public JULLoggingApiSpecification(Function<String, TargetLogLevel> targetLogLevelFunction, LogMessageFactory logMessageFactory) {
        super(targetLogLevelFunction, logMessageFactory);
    }

    @Override
    public boolean matchConditionalMethod(ExpressionTree expressionTree, VisitorState state) {
        return JULMatchers.loggingEnabledMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLoggingMethod(ExpressionTree expressionTree, VisitorState state) {
        return JULMatchers.loggingMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLogFactory(VariableTree variableTree, VisitorState visitorState) {
        return JULMatchers.loggerFactoryMethod().matches((Tree)variableTree.getInitializer(), visitorState);
    }

    @Override
    public boolean matchImport(Tree qualifiedIdentifier, VisitorState visitorState) {
        return JULMatchers.loggerImports().matches(qualifiedIdentifier, visitorState);
    }

    @Override
    public boolean shouldRemoveImport(String importString) {
        return LOGGING_PACKAGE_PREFIXES.stream().anyMatch(importString::startsWith);
    }

    @Override
    public FloggerConditionalStatement parseConditionalMethod(MethodInvocation methodInvocation) {
        ImmutableFloggerConditionalStatement.Builder builder = ImmutableFloggerConditionalStatement.builder();
        builder.targetLogLevel(this.resolveLogLevelFromArgument(methodInvocation.firstArgument()));
        builder.conditionalStatement(methodInvocation);
        return builder.build();
    }

    private TargetLogLevel resolveLogLevelFromArgument(ExpressionTree levelArgument) {
        try {
            if (levelArgument instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)levelArgument;
                if (fieldAccess.selected.type.toString().equals("java.util.logging.Level")) {
                    return this.mapLogLevel(fieldAccess.name.toString());
                }
            }
            return TargetLogLevel.customLogLevel(levelArgument);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SkipCompilationUnitException("Custom log level not supported: " + levelArgument);
        }
    }

    @Override
    public FloggerLogStatement parseLoggingMethod(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        if ("throwing".equals(methodInvocation.methodName())) {
            return this.parseThrowing(methodInvocation, migrationContext);
        }
        if (ENTERING_EXITING_METHOD_NAMES.contains(methodInvocation.methodName())) {
            return this.parseEnteringExiting(methodInvocation, migrationContext);
        }
        return this.parseLog(methodInvocation, migrationContext);
    }

    private FloggerLogStatement parseLog(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        ArgumentParser argumentParser = ArgumentParser.forArgumentsOf(methodInvocation);
        TargetLogLevel targetLogLevel = this.determineTargetLogLevel(methodInvocation, argumentParser);
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        ExpressionTree messageFormatArgument = argumentParser.extract();
        argumentParser.maybeUnpackVarArgs();
        ExpressionTree throwableArgument = argumentParser.trailingThrowable();
        builder.thrown(throwableArgument);
        LogMessage logMessage = this.createLogMessage(messageFormatArgument, argumentParser.remainingArguments(), methodInvocation.state(), throwableArgument, migrationContext, targetLogLevel);
        builder.logMessage(logMessage);
        return builder.build();
    }

    private FloggerLogStatement parseEnteringExiting(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        TargetLogLevel targetLogLevel = this.mapLogLevel("finer");
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        ArgumentParser argumentParser = ArgumentParser.forArgumentsOf(methodInvocation);
        argumentParser.skip(2);
        String msgPrefix = this.determineEnteringExitingPrefix(methodInvocation.methodName());
        StringBuilder sb = new StringBuilder();
        sb.append(msgPrefix);
        List<? extends ExpressionTree> args = argumentParser.remainingArguments();
        if (!argumentParser.isEmpty()) {
            args = Arguments.maybeUnpackVarArgs(args, methodInvocation.state());
            for (int i = 0; i < args.size(); ++i) {
                sb.append(" %s");
            }
        }
        LogMessage logMessage = this.createLogMessage(sb.toString(), args, methodInvocation.state(), targetLogLevel);
        builder.logMessage(logMessage);
        return builder.build();
    }

    private String determineEnteringExitingPrefix(String methodName) {
        return methodName.equals("entering") ? "ENTRY" : "RETURN";
    }

    private FloggerLogStatement parseThrowing(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        TargetLogLevel targetLogLevel = this.mapLogLevel("finer");
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        ExpressionTree throwableArgument = methodInvocation.tree().getArguments().get(2);
        builder.thrown(throwableArgument);
        builder.logMessage(LogMessage.fromStringFormat("THROW", (List<MessageFormatArgument>)ImmutableList.of()));
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TargetLogLevel determineTargetLogLevel(MethodInvocation methodInvocation, ArgumentParser argumentParser) {
        if (!methodInvocation.methodName().equals("log")) return this.mapLogLevel(methodInvocation.methodName());
        ExpressionTree logLevelArgument = argumentParser.extract();
        if (!JULMatchers.logLevelType().matches((Tree)logLevelArgument, methodInvocation.state())) throw new SkipLogMethodException("Unable to determine log level");
        return this.resolveLogLevelFromArgument(logLevelArgument);
    }
}

