/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.jul;

import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

final class JULMatchers {
    private static final String LOGGER_CLASS = "java.util.logging.Logger";
    private static final String LOGGER_FACTORY_CLASS = "java.util.logging.Logger";
    private static final Matcher<ExpressionTree> LOGGER_FACTORY_MATCHER = Matchers.methodInvocation((Matcher)Matchers.staticMethod().onClass("java.util.logging.Logger").named("getLogger"));
    private static final Matcher<Tree> LOGGER_TYPE_MATCHER = Matchers.isSubtypeOf((String)"java.util.logging.Logger");
    private static final Matcher<Tree> LOGGER_FACTORY_TYPE_MATCHER = Matchers.isSubtypeOf((String)"java.util.logging.Logger");
    private static final Matcher<ExpressionTree> LOGGING_METHODS = Matchers.instanceMethod().onDescendantOf("java.util.logging.Logger").namedAnyOf(new String[]{"finest", "finer", "fine", "config", "info", "warning", "severe", "log", "throwing", "entering", "exiting"});
    private static final Matcher<ExpressionTree> IS_ENABLED_METHODS = Matchers.instanceMethod().onDescendantOf("java.util.logging.Logger").namedAnyOf(new String[]{"isLoggable"});
    private static final Matcher<Tree> LOG_LEVEL_TYPE = Matchers.isSameType((String)"java.util.logging.Level");
    private static final Matcher<Tree> IMPORT_TYPES = Matchers.anyOf((Matcher[])new Matcher[]{LOGGER_TYPE_MATCHER, LOGGER_FACTORY_TYPE_MATCHER, LOG_LEVEL_TYPE});

    static Matcher<Tree> logLevelType() {
        return LOG_LEVEL_TYPE;
    }

    static Matcher<ExpressionTree> loggingMethod() {
        return LOGGING_METHODS;
    }

    static Matcher<ExpressionTree> loggingEnabledMethod() {
        return IS_ENABLED_METHODS;
    }

    static Matcher<ExpressionTree> loggerFactoryMethod() {
        return LOGGER_FACTORY_MATCHER;
    }

    static Matcher<Tree> loggerImports() {
        return IMPORT_TYPES;
    }

    private JULMatchers() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }
}

