/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.log4j;

import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

final class Log4jMatchers {
    private static final String LOG4J_LOGGER_CLASS = "org.apache.log4j.Category";
    private static final String LOG4J_LOG_MANAGER_CLASS = "org.apache.log4j.LogManager";
    private static final Matcher<ExpressionTree> IS_ENABLED_METHODS = Matchers.instanceMethod().onDescendantOf("org.apache.log4j.Category").namedAnyOf(new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isFatalEnabled", "isEnabledFor"});
    private static final Matcher<ExpressionTree> LOGGING_METHODS = Matchers.instanceMethod().onDescendantOf("org.apache.log4j.Category").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error", "fatal", "log"});
    private static final Matcher<ExpressionTree> LOG_MANAGER_MATCHER = Matchers.methodInvocation((Matcher)Matchers.staticMethod().onClass("org.apache.log4j.LogManager").namedAnyOf(new String[]{"getLogger"}));
    private static final Matcher<Tree> LOGGER_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.apache.log4j.Category");
    private static final Matcher<Tree> LOGGER_FACTORY_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.apache.log4j.LogManager");
    private static final Matcher<Tree> LOG4J_LOGGER_TYPES = Matchers.anyOf((Matcher[])new Matcher[]{LOGGER_TYPE_MATCHER, LOGGER_FACTORY_TYPE_MATCHER, Matchers.isSubtypeOf((String)"org.apache.log4j.Priority")});

    static Matcher<ExpressionTree> loggingMethod() {
        return LOGGING_METHODS;
    }

    static Matcher<ExpressionTree> loggingEnabledMethod() {
        return IS_ENABLED_METHODS;
    }

    static Matcher<ExpressionTree> logManagerMethod() {
        return LOG_MANAGER_MATCHER;
    }

    static Matcher<Tree> loggerImports() {
        return LOG4J_LOGGER_TYPES;
    }

    private Log4jMatchers() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }
}

