/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.log4j2;

final class Log4j2BraceMessageFormatConverter {
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';

    Log4j2BraceMessageFormatConverter() {
    }

    static String convertMessageFormat(String messagePattern) {
        int i;
        StringBuilder buffer = new StringBuilder(messagePattern.length() + 50);
        messagePattern = messagePattern.replace("%", "%%");
        int escapeCounter = 0;
        int len = messagePattern.length();
        for (i = 0; i < len - 1; ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (Log4j2BraceMessageFormatConverter.isDelimPair(curChar, messagePattern, i)) {
                ++i;
                Log4j2BraceMessageFormatConverter.writeEscapedEscapeChars(escapeCounter, buffer);
                if (Log4j2BraceMessageFormatConverter.isOdd(escapeCounter)) {
                    Log4j2BraceMessageFormatConverter.writeDelimPair(buffer);
                } else {
                    buffer.append("%s");
                }
            } else {
                Log4j2BraceMessageFormatConverter.handleLiteralChar(buffer, escapeCounter, curChar);
            }
            escapeCounter = 0;
        }
        Log4j2BraceMessageFormatConverter.handleRemainingCharIfAny(messagePattern, len, buffer, escapeCounter, i);
        return buffer.toString();
    }

    private static boolean isDelimPair(char curChar, String messagePattern, int curCharIndex) {
        return curChar == '{' && messagePattern.charAt(curCharIndex + 1) == '}';
    }

    private static void handleRemainingCharIfAny(String messagePattern, int len, StringBuilder buffer, int escapeCounter, int i) {
        if (i == len - 1) {
            char curChar = messagePattern.charAt(i);
            Log4j2BraceMessageFormatConverter.handleLastChar(buffer, escapeCounter, curChar);
        }
    }

    private static void handleLastChar(StringBuilder buffer, int escapeCounter, char curChar) {
        if (curChar == '\\') {
            Log4j2BraceMessageFormatConverter.writeUnescapedEscapeChars(escapeCounter + 1, buffer);
        } else {
            Log4j2BraceMessageFormatConverter.handleLiteralChar(buffer, escapeCounter, curChar);
        }
    }

    private static void handleLiteralChar(StringBuilder buffer, int escapeCounter, char curChar) {
        Log4j2BraceMessageFormatConverter.writeUnescapedEscapeChars(escapeCounter, buffer);
        buffer.append(curChar);
    }

    private static void writeDelimPair(StringBuilder buffer) {
        buffer.append('{');
        buffer.append('}');
    }

    private static boolean isOdd(int number) {
        return (number & 1) == 1;
    }

    private static void writeEscapedEscapeChars(int escapeCounter, StringBuilder buffer) {
        int escapedEscapes = escapeCounter >> 1;
        Log4j2BraceMessageFormatConverter.writeUnescapedEscapeChars(escapedEscapes, buffer);
    }

    private static void writeUnescapedEscapeChars(int escapeCounter, StringBuilder buffer) {
        while (escapeCounter > 0) {
            buffer.append('\\');
            --escapeCounter;
        }
    }
}

