/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.log4j2;

import com.digitalascent.errorprone.flogger.migrate.SkipCompilationUnitException;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.ArgumentParser;
import com.digitalascent.errorprone.flogger.migrate.source.api.AbstractLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.SourceApiUtil;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j2.Log4j2Matchers;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import java.util.function.Function;

public final class Log4j2LoggingApiSpecification
extends AbstractLoggingApiSpecification {
    private static final Set<String> LOGGING_PACKAGE_PREFIXES = ImmutableSet.of((Object)"org.apache.logging.log4j");
    private static final Set<String> LOGGING_IMPORTS_TO_RETAIN = ImmutableSet.of((Object)"org.apache.logging.log4j.message.Message");

    public Log4j2LoggingApiSpecification(Function<String, TargetLogLevel> targetLogLevelFunction, LogMessageFactory logMessageFactory) {
        super(targetLogLevelFunction, logMessageFactory);
    }

    @Override
    public boolean matchConditionalMethod(ExpressionTree expressionTree, VisitorState state) {
        return Log4j2Matchers.loggingEnabledMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLoggingMethod(ExpressionTree expressionTree, VisitorState state) {
        return Log4j2Matchers.loggingMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean shouldRemoveImport(String importString) {
        if (LOGGING_IMPORTS_TO_RETAIN.contains(importString)) {
            return false;
        }
        return LOGGING_PACKAGE_PREFIXES.stream().anyMatch(importString::startsWith);
    }

    @Override
    public boolean matchLogFactory(VariableTree variableTree, VisitorState visitorState) {
        return Log4j2Matchers.logManagerMethod().matches((Tree)variableTree.getInitializer(), visitorState);
    }

    @Override
    public boolean matchImport(Tree qualifiedIdentifier, VisitorState visitorState) {
        return Log4j2Matchers.loggerImports().matches(qualifiedIdentifier, visitorState);
    }

    @Override
    public FloggerConditionalStatement parseConditionalMethod(MethodInvocation methodInvocation) {
        ImmutableFloggerConditionalStatement.Builder builder = ImmutableFloggerConditionalStatement.builder();
        builder.targetLogLevel(this.determineTargetLogLevel(methodInvocation));
        builder.conditionalStatement(methodInvocation);
        return builder.build();
    }

    private TargetLogLevel determineTargetLogLevel(MethodInvocation methodInvocation) {
        TargetLogLevel targetLogLevel;
        if (methodInvocation.methodName().equals("isEnabled")) {
            targetLogLevel = this.resolveLogLevelFromArgument(methodInvocation.firstArgument());
        } else {
            String level = SourceApiUtil.logLevelFromMethodName(methodInvocation);
            targetLogLevel = this.mapLogLevel(level);
        }
        return targetLogLevel;
    }

    private TargetLogLevel resolveLogLevelFromArgument(ExpressionTree levelArgument) {
        try {
            if (levelArgument instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)levelArgument;
                return this.mapLogLevel(fieldAccess.name.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new SkipCompilationUnitException("Custom log level not supported: " + levelArgument);
    }

    @Override
    public FloggerLogStatement parseLoggingMethod(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        ArgumentParser argumentParser = ArgumentParser.forArgumentsOf(methodInvocation);
        TargetLogLevel targetLogLevel = this.determineTargetLogLevel(methodInvocation, argumentParser);
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        argumentParser.skipIfPresent(argument -> Log4j2Matchers.markerType().matches((Tree)argument, methodInvocation.state()));
        ExpressionTree messageFormatArgument = argumentParser.extract();
        argumentParser.maybeUnpackVarArgs();
        ExpressionTree throwableArgument = argumentParser.trailingThrowable();
        builder.thrown(throwableArgument);
        LogMessage logMessage = this.createLogMessage(messageFormatArgument, argumentParser.remainingArguments(), methodInvocation.state(), throwableArgument, migrationContext, targetLogLevel);
        builder.logMessage(logMessage);
        return builder.build();
    }

    private TargetLogLevel determineTargetLogLevel(MethodInvocation methodInvocation, ArgumentParser argumentParser) {
        TargetLogLevel targetLogLevel;
        if (methodInvocation.methodName().equals("log") || methodInvocation.methodName().equals("printf")) {
            ExpressionTree logLevelArgument = argumentParser.extract();
            targetLogLevel = this.resolveLogLevelFromArgument(logLevelArgument);
        } else {
            targetLogLevel = this.mapLogLevel(methodInvocation.methodName());
        }
        return targetLogLevel;
    }
}

