/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.log4j2;

import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.source.api.log4j2.Log4j2BraceMessageFormatConverter;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionResult;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatStyle;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.List;
import javax.annotation.Nullable;

public final class Log4j2MessageFormatSpecification
implements MessageFormatSpecification {
    @Nullable
    private final MessageFormatStyle messageFormatStyle;

    public Log4j2MessageFormatSpecification(@Nullable MessageFormatStyle messageFormatStyle) {
        this.messageFormatStyle = messageFormatStyle;
    }

    @Override
    public boolean shouldSkipMessageFormatArgument(ExpressionTree messageFormatArgument, VisitorState state) {
        return false;
    }

    @Override
    public MessageFormatConversionResult convertMessageFormat(ExpressionTree messageFormatArgument, String sourceMessageFormat, List<? extends ExpressionTree> formatArguments, MigrationContext migrationContext) {
        if (migrationContext.classNamedLoggers().isEmpty() && this.messageFormatStyle != null) {
            switch (this.messageFormatStyle) {
                case LOG4J2_BRACE: {
                    String format = Log4j2BraceMessageFormatConverter.convertMessageFormat(sourceMessageFormat);
                    return new MessageFormatConversionResult(format, formatArguments);
                }
                case PRINTF: {
                    return new MessageFormatConversionResult(sourceMessageFormat, formatArguments);
                }
            }
            throw new AssertionError((Object)("Unknown message format style: " + (Object)((Object)this.messageFormatStyle)));
        }
        MethodInvocationTree logFactoryMethodInvocationTree = (MethodInvocationTree)migrationContext.classNamedLoggers().get(0).getInitializer();
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)logFactoryMethodInvocationTree);
        String methodName = ((Name)sym.getSimpleName()).toString();
        if ("getLogger".equals(methodName)) {
            String format = Log4j2BraceMessageFormatConverter.convertMessageFormat(sourceMessageFormat);
            return new MessageFormatConversionResult(format, formatArguments);
        }
        return new MessageFormatConversionResult(sourceMessageFormat, formatArguments);
    }
}

