/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.slf4j;

import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

final class Slf4jMatchers {
    private static final String SLF4J_LOGGER_CLASS = "org.slf4j.Logger";
    private static final String SLF4J_MARKER_CLASS = "org.slf4j.Marker";
    private static final String SLF4J_LOGGER_FACTORY_CLASS = "org.slf4j.LoggerFactory";
    private static final Matcher<ExpressionTree> MARKER_MATCHER = Matchers.isSubtypeOf((String)"org.slf4j.Marker");
    private static final Matcher<ExpressionTree> LOGGER_FACTORY_MATCHER = Matchers.methodInvocation((Matcher)Matchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger"));
    private static final Matcher<Tree> LOGGER_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.slf4j.Logger");
    private static final Matcher<Tree> LOGGER_FACTORY_TYPE_MATCHER = Matchers.isSubtypeOf((String)"org.slf4j.LoggerFactory");
    private static final Matcher<ExpressionTree> LOGGING_METHODS = Matchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error"});
    private static final Matcher<ExpressionTree> IS_ENABLED_METHODS = Matchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled"});
    private static final Matcher<Tree> SLF4J_LOGGER_TYPES = Matchers.anyOf((Matcher[])new Matcher[]{LOGGER_TYPE_MATCHER, LOGGER_FACTORY_TYPE_MATCHER});

    static Matcher<ExpressionTree> loggingMethod() {
        return LOGGING_METHODS;
    }

    static Matcher<ExpressionTree> loggingEnabledMethod() {
        return IS_ENABLED_METHODS;
    }

    static Matcher<ExpressionTree> markerType() {
        return MARKER_MATCHER;
    }

    static Matcher<ExpressionTree> loggerFactoryMethod() {
        return LOGGER_FACTORY_MATCHER;
    }

    static Matcher<Tree> loggerImports() {
        return SLF4J_LOGGER_TYPES;
    }

    private Slf4jMatchers() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }
}

