/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.slf4j;

final class Slf4jMessageFormatConverter {
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    Slf4jMessageFormatConverter() {
    }

    static String convertMessageFormat(String messagePattern) {
        messagePattern = messagePattern.replace("%", "%%");
        int nextIndex = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        while (true) {
            int delimiterIndex;
            if ((delimiterIndex = messagePattern.indexOf(DELIM_STR, nextIndex)) == -1) {
                if (nextIndex == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern, nextIndex, messagePattern.length());
                return sbuf.toString();
            }
            if (Slf4jMessageFormatConverter.isEscapedDelimeter(messagePattern, delimiterIndex)) {
                if (Slf4jMessageFormatConverter.isDoubleEscaped(messagePattern, delimiterIndex)) {
                    sbuf.append(messagePattern, nextIndex, delimiterIndex - 1);
                    Slf4jMessageFormatConverter.appendPrintfPlaceholder(sbuf);
                    nextIndex = delimiterIndex + 2;
                    continue;
                }
                sbuf.append(messagePattern, nextIndex, delimiterIndex - 1);
                sbuf.append(DELIM_STR);
                nextIndex = delimiterIndex + 2;
                continue;
            }
            sbuf.append(messagePattern, nextIndex, delimiterIndex);
            Slf4jMessageFormatConverter.appendPrintfPlaceholder(sbuf);
            nextIndex = delimiterIndex + 2;
        }
    }

    private static void appendPrintfPlaceholder(StringBuilder sbuf) {
        sbuf.append("%s");
    }

    private static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    private static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }
}

