/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.tinylog2;

import com.digitalascent.errorprone.flogger.migrate.model.FloggerConditionalStatement;
import com.digitalascent.errorprone.flogger.migrate.model.FloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.ImmutableFloggerLogStatement;
import com.digitalascent.errorprone.flogger.migrate.model.LogMessage;
import com.digitalascent.errorprone.flogger.migrate.model.MethodInvocation;
import com.digitalascent.errorprone.flogger.migrate.model.MigrationContext;
import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.ArgumentParser;
import com.digitalascent.errorprone.flogger.migrate.source.api.AbstractLoggingApiSpecification;
import com.digitalascent.errorprone.flogger.migrate.source.api.LogMessageFactory;
import com.digitalascent.errorprone.flogger.migrate.source.api.tinylog2.TinyLog2Matchers;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Set;
import java.util.function.Function;

public final class TinyLog2LoggingApiSpecification
extends AbstractLoggingApiSpecification {
    private static final Set<String> LOGGING_PACKAGE_PREFIXES = ImmutableSet.of((Object)"org.tinylog");

    public TinyLog2LoggingApiSpecification(Function<String, TargetLogLevel> targetLogLevelFunction, LogMessageFactory logMessageFactory) {
        super(targetLogLevelFunction, logMessageFactory);
    }

    @Override
    public boolean matchConditionalMethod(ExpressionTree expressionTree, VisitorState state) {
        return false;
    }

    @Override
    public boolean matchLoggingMethod(ExpressionTree expressionTree, VisitorState state) {
        return TinyLog2Matchers.loggingMethod().matches((Tree)expressionTree, state);
    }

    @Override
    public boolean matchLogFactory(VariableTree variableTree, VisitorState visitorState) {
        return false;
    }

    @Override
    public FloggerConditionalStatement parseConditionalMethod(MethodInvocation methodInvocation) {
        throw new UnsupportedOperationException("TinyLog2 doesn't have logging enabled methods");
    }

    @Override
    public boolean matchImport(Tree qualifiedIdentifier, VisitorState visitorState) {
        return TinyLog2Matchers.loggerImports().matches(qualifiedIdentifier, visitorState);
    }

    @Override
    public boolean shouldRemoveImport(String importString) {
        return LOGGING_PACKAGE_PREFIXES.stream().anyMatch(importString::startsWith);
    }

    @Override
    public FloggerLogStatement parseLoggingMethod(MethodInvocation methodInvocation, MigrationContext migrationContext) {
        TargetLogLevel targetLogLevel = this.mapLogLevel(methodInvocation.methodName());
        ImmutableFloggerLogStatement.Builder builder = ImmutableFloggerLogStatement.builder();
        builder.targetLogLevel(targetLogLevel);
        ArgumentParser argumentParser = ArgumentParser.forArgumentsOf(methodInvocation);
        ExpressionTree throwableArgument = argumentParser.extractIfMatches(argument -> TinyLog2Matchers.throwableType().matches((Tree)argument, methodInvocation.state()));
        builder.thrown(throwableArgument);
        ExpressionTree messageFormatArgument = argumentParser.extractOrElse(throwableArgument);
        argumentParser.maybeUnpackVarArgs();
        LogMessage logMessage = this.createLogMessage(messageFormatArgument, argumentParser.remainingArguments(), methodInvocation.state(), throwableArgument, migrationContext, targetLogLevel);
        builder.logMessage(logMessage);
        return builder.build();
    }
}

