/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.api.tinylog2;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;

final class TinyLog2MessageFormatter {
    private static final DecimalFormatSymbols FORMATTER_SYMBOLS = new DecimalFormatSymbols(Locale.ENGLISH);

    private TinyLog2MessageFormatter() {
        throw new AssertionError((Object)("Cannot instantiate " + this.getClass()));
    }

    static String format(String message) {
        message = message.replace("%", "%%");
        StringBuilder builder = new StringBuilder(256);
        int start = 0;
        int openBraces = 0;
        for (int index = 0; index < message.length(); ++index) {
            char character = message.charAt(index);
            if (character == '{') {
                if (openBraces++ != 0 || start >= index) continue;
                builder.append(message, start, index);
                start = index;
                continue;
            }
            if (character != '}' || openBraces <= 0 || --openBraces != 0) continue;
            if (index == start + 1) {
                builder.append("%s");
            } else {
                builder.append(TinyLog2MessageFormatter.format(message.substring(start + 1, index), "%s"));
            }
            start = index + 1;
        }
        if (start < message.length()) {
            builder.append(message, start, message.length());
        }
        return builder.toString();
    }

    private static String format(String pattern, Object argument) {
        try {
            return TinyLog2MessageFormatter.getFormatter(pattern, argument).format(argument);
        }
        catch (IllegalArgumentException ex) {
            return String.valueOf(argument);
        }
    }

    private static Format getFormatter(String pattern, Object argument) {
        if (pattern.indexOf(124) != -1) {
            int start = pattern.indexOf(123);
            if (start >= 0 && start < pattern.lastIndexOf(125)) {
                return new ChoiceFormat(TinyLog2MessageFormatter.format(pattern, new Object[]{argument}));
            }
            return new ChoiceFormat(pattern);
        }
        return new DecimalFormat(pattern, FORMATTER_SYMBOLS);
    }
}

