/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format;

import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionFailedException;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionResult;
import com.sun.source.tree.ExpressionTree;
import java.lang.reflect.Field;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MessageFormat {
    public static MessageFormatConversionResult convertJavaTextMessageFormat(String sourceMessageFormat, List<? extends ExpressionTree> formatArguments) {
        try {
            java.text.MessageFormat messageFormat = new java.text.MessageFormat(sourceMessageFormat);
            MessageFormat.resetFormats(messageFormat);
            messageFormat.applyPattern(messageFormat.toPattern().replace("%", "%%"));
            int[] argumentNumbers = MessageFormat.determineArgumentNumbers(messageFormat);
            int max = Arrays.stream(argumentNumbers).max().getAsInt() + 1;
            int maxOffset = MessageFormat.determineMaxOffset(messageFormat);
            ArrayList<ExpressionTree> argumentList = new ArrayList<ExpressionTree>();
            ArrayList<String> migrationIssues = new ArrayList<String>();
            for (int i = 0; i <= maxOffset; ++i) {
                int n = argumentNumbers[i];
                if (n < formatArguments.size()) {
                    argumentList.add(formatArguments.get(n));
                    continue;
                }
                migrationIssues.add("Invalid parameter index: " + n + ": \"" + messageFormat.toPattern() + "\"");
            }
            for (ExpressionTree expressionTree : formatArguments) {
                if (argumentList.contains(expressionTree)) continue;
                migrationIssues.add("Unused parameter: " + expressionTree.toString().replace("\r", "\\r").replace("\n", "\\n"));
                argumentList.add(expressionTree);
            }
            Object[] args = new Object[max];
            Arrays.fill(args, "%s");
            String string = messageFormat.format(args);
            return new MessageFormatConversionResult(string, argumentList, migrationIssues);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MessageFormatConversionFailedException(e.getMessage());
        }
    }

    private static int[] determineArgumentNumbers(java.text.MessageFormat messageFormat) throws NoSuchFieldException, IllegalAccessException {
        Field argumentNumbersField = MessageFormat.createField(messageFormat, "argumentNumbers");
        return (int[])argumentNumbersField.get(messageFormat);
    }

    private static int determineMaxOffset(java.text.MessageFormat messageFormat) throws NoSuchFieldException, IllegalAccessException {
        Field maxOffsetField = MessageFormat.createField(messageFormat, "maxOffset");
        return (Integer)maxOffsetField.get(messageFormat);
    }

    private static void resetFormats(java.text.MessageFormat messageFormat) throws NoSuchFieldException, IllegalAccessException {
        Field formatsField = MessageFormat.createField(messageFormat, "formats");
        Object[] formats = (Format[])formatsField.get(messageFormat);
        Arrays.fill(formats, null);
    }

    private static Field createField(java.text.MessageFormat messageFormat, String fieldName) throws NoSuchFieldException {
        Field field = messageFormat.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    private MessageFormat() {
        throw new AssertionError((Object)("Cannot instantiate: " + this.getClass()));
    }
}

