/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.Nullable;

public final class MessageFormatArgument {
    private final List<String> staticImports;
    private final List<String> imports;
    @Nullable
    private final String code;
    @Nullable
    private final ExpressionTree argument;

    private MessageFormatArgument(@Nullable String code, @Nullable ExpressionTree argument, List<String> imports, List<String> staticImports) {
        this.code = code;
        this.argument = argument;
        this.imports = ImmutableList.copyOf(imports);
        this.staticImports = ImmutableList.copyOf(staticImports);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("staticImports", this.staticImports).add("imports", this.imports).add("code", (Object)this.code).add("argument", (Object)this.argument).toString();
    }

    public static MessageFormatArgument fromExpressionTree(ExpressionTree argument) {
        return new MessageFormatArgument(null, argument, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    public static MessageFormatArgument fromCode(String code, List<String> imports, List<String> staticImports) {
        return new MessageFormatArgument(code, null, imports, staticImports);
    }

    public String code(VisitorState visitorState) {
        return this.code != null ? this.code : visitorState.getSourceForNode((Tree)this.argument);
    }

    public List<String> staticImports() {
        return this.staticImports;
    }

    public List<String> imports() {
        return this.imports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageFormatArgument that = (MessageFormatArgument)o;
        return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal((Object)this.argument, (Object)that.argument);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.code, this.argument});
    }
}

