/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format;

import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.Arguments;
import com.digitalascent.errorprone.flogger.migrate.source.format.EmptyArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormat;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionResult;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.Nullable;

public final class MessageFormatEmptyArgumentsHandler
implements EmptyArgumentsHandler {
    private static final MethodMatchers.MethodNameMatcher MESSAGE_FORMAT = Matchers.staticMethod().onClass("java.text.MessageFormat").named("format");

    @Override
    @Nullable
    public MessageFormatConversionResult handle(ExpressionTree messageFormatArgument, VisitorState state, TargetLogLevel targetLogLevel) {
        if (!MESSAGE_FORMAT.matches((Tree)messageFormatArgument, state)) {
            return null;
        }
        MethodInvocationTree messageFormatTree = (MethodInvocationTree)messageFormatArgument;
        ExpressionTree firstArgument = messageFormatTree.getArguments().get(0);
        if (firstArgument instanceof LiteralTree) {
            String messageFormat = (String)((LiteralTree)firstArgument).getValue();
            List<? extends ExpressionTree> remainingArguments = Arguments.removeFirst(messageFormatTree.getArguments());
            return MessageFormat.convertJavaTextMessageFormat(messageFormat, remainingArguments);
        }
        return null;
    }
}

