/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format;

import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.format.EmptyArgumentsHandler;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatConversionResult;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class StringConcatenationEmptyArgumentsHandler
implements EmptyArgumentsHandler {
    private static final Matcher<BinaryTree> STRING_CONCATENATION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.PLUS), Matchers.binaryTree((Matcher)Matchers.anything(), (Matcher)Matchers.isSameType((String)"java.lang.String"))});

    @Override
    @Nullable
    public MessageFormatConversionResult handle(ExpressionTree messageFormatArgument, VisitorState state, TargetLogLevel targetLogLevel) {
        if (!(messageFormatArgument instanceof BinaryTree)) {
            return null;
        }
        BinaryTree binaryTree = (BinaryTree)messageFormatArgument;
        if (!STRING_CONCATENATION_MATCHER.matches((Tree)binaryTree, state)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        this.handleBinaryTree(binaryTree, sb, arguments);
        return new MessageFormatConversionResult(sb.toString(), arguments);
    }

    private void handleBinaryTree(BinaryTree binaryTree, StringBuilder sb, List<ExpressionTree> arguments) {
        ExpressionTree lhs = binaryTree.getLeftOperand();
        ExpressionTree rhs = binaryTree.getRightOperand();
        if (lhs instanceof BinaryTree) {
            this.handleBinaryTree((BinaryTree)lhs, sb, arguments);
        } else if (lhs instanceof LiteralTree) {
            this.handleLiteral(sb, arguments, lhs);
        } else {
            this.addArgument(sb, arguments, lhs);
        }
        if (rhs instanceof LiteralTree) {
            this.handleLiteral(sb, arguments, rhs);
        } else {
            this.addArgument(sb, arguments, rhs);
        }
    }

    private void handleLiteral(StringBuilder sb, List<ExpressionTree> arguments, ExpressionTree node) {
        LiteralTree literalTree = (LiteralTree)node;
        Object value = literalTree.getValue();
        if (value instanceof String) {
            sb.append(value);
        } else {
            this.addArgument(sb, arguments, node);
        }
    }

    private void addArgument(StringBuilder sb, List<ExpressionTree> arguments, ExpressionTree node) {
        sb.append("%s");
        arguments.add(node);
    }
}

