/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format.argconverter;

import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.format.MessageFormatArgument;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.MessageFormatArgumentConverter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.List;

abstract class AbstractLazyArgConverter
implements MessageFormatArgumentConverter {
    private static final ImmutableList<String> LAZY_ARG_IMPORT = ImmutableList.of((Object)"com.google.common.flogger.LazyArgs.lazy");

    AbstractLazyArgConverter() {
    }

    @Override
    public final MessageFormatArgument convert(ExpressionTree argument, VisitorState visitorState, TargetLogLevel targetLogLevel) {
        if (this.matches(argument, visitorState, targetLogLevel)) {
            String rawSource = visitorState.getSourceForNode((Tree)argument);
            if (rawSource == null) {
                return null;
            }
            String source = this.decorate(rawSource);
            return this.lazyArgument(source);
        }
        return null;
    }

    protected abstract String decorate(String var1);

    protected abstract boolean matches(ExpressionTree var1, VisitorState var2, TargetLogLevel var3);

    private MessageFormatArgument lazyArgument(String code) {
        String source = "lazy(" + code + ")";
        return MessageFormatArgument.fromCode(source, (List<String>)ImmutableList.of(), LAZY_ARG_IMPORT);
    }
}

