/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format.argconverter;

import com.digitalascent.errorprone.flogger.migrate.model.TargetLogLevel;
import com.digitalascent.errorprone.flogger.migrate.source.format.argconverter.AbstractLazyArgConverter;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import java.util.function.Predicate;

public final class LazyMessageFormatArgumentConverter
extends AbstractLazyArgConverter {
    private final Predicate<TargetLogLevel> lazyLogLevelPredicate;

    public LazyMessageFormatArgumentConverter(Predicate<TargetLogLevel> lazyLogLevelPredicate) {
        this.lazyLogLevelPredicate = Objects.requireNonNull(lazyLogLevelPredicate, "lazyLogLevelPredicate");
    }

    @Override
    protected String decorate(String rawSource) {
        return "() -> " + rawSource;
    }

    @Override
    protected boolean matches(ExpressionTree argument, VisitorState visitorState, TargetLogLevel targetLogLevel) {
        return this.isLazyLogLevel(targetLogLevel) && this.isLazyArgument(argument, visitorState);
    }

    private boolean isLazyLogLevel(TargetLogLevel targetLogLevel) {
        return this.lazyLogLevelPredicate.test(targetLogLevel);
    }

    private boolean isLazyArgument(ExpressionTree argument, VisitorState visitorState) {
        return Matchers.anyMethod().matches((Tree)argument, visitorState) || argument instanceof NewClassTree || argument instanceof NewArrayTree;
    }
}

