/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.errorprone.flogger.migrate.source.format.reducer;

import com.digitalascent.errorprone.flogger.migrate.source.format.reducer.MessageFormatArgumentReducer;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.ExpressionTree;
import java.util.List;

public final class CompositeMessageFormatArgumentReducer
implements MessageFormatArgumentReducer {
    private final List<MessageFormatArgumentReducer> reducers;

    public CompositeMessageFormatArgumentReducer(List<MessageFormatArgumentReducer> reducers) {
        this.reducers = ImmutableList.copyOf(reducers);
    }

    @Override
    public ExpressionTree reduce(ExpressionTree argument, VisitorState visitorState) {
        ExpressionTree lastReducedArgument = argument;
        for (MessageFormatArgumentReducer reducer : this.reducers) {
            ExpressionTree reducedArgument = reducer.reduce(lastReducedArgument, visitorState);
            if (reducedArgument == null) continue;
            lastReducedArgument = reducedArgument;
        }
        return lastReducedArgument == argument ? argument : this.reduce(lastReducedArgument, visitorState);
    }
}

