/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.servlet;

import com.digitalascent.common.base.StaticUtilityClass;
import com.digitalascent.common.collect.ExtraStreams;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class HttpRequests {
    @Nonnull
    public static Optional<String> headerValue(HttpServletRequest request, String headerName) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)headerName) ? 1 : 0) != 0, (String)"headerName is required to be non-null & not empty: %s", (Object)headerName);
        return Optional.ofNullable(request.getHeader(headerName));
    }

    @Nonnull
    public static Optional<String> headerValue(HttpServletRequest request, String ... headerNames) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        Preconditions.checkNotNull((Object)headerNames, (Object)"headerNames is required");
        return Arrays.stream(headerNames).map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).findFirst();
    }

    @Nonnull
    public static Stream<String> headerNames(HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        return ExtraStreams.streamFor((Enumeration)request.getHeaderNames());
    }

    @Nonnull
    public static Stream<Cookie> cookies(HttpServletRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return Stream.empty();
        }
        return Arrays.stream(cookies);
    }

    @Nonnull
    public static Optional<Cookie> cookie(HttpServletRequest request, String cookieName) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cookieName) ? 1 : 0) != 0, (String)"cookieName is required to be non-null & not empty: %s", (Object)cookieName);
        return HttpRequests.cookies(request).filter(cookie -> Objects.equals(cookie.getName(), cookieName)).findFirst();
    }

    @Nonnull
    public static Optional<String> cookieValue(HttpServletRequest request, String cookieName) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cookieName) ? 1 : 0) != 0, (String)"cookieName is required to be non-null & not empty: %s", (Object)cookieName);
        return HttpRequests.cookie(request, cookieName).map(Cookie::getValue);
    }

    private HttpRequests() {
        StaticUtilityClass.throwCannotInstantiateError(this.getClass());
    }
}

