/*
 * Decompiled with CFR 0.152.
 */
package com.digitalascent.servlet;

import com.digitalascent.common.base.StaticUtilityClass;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class HttpSessions {
    @Nonnull
    public static <T> Optional<T> attribute(HttpServletRequest request, String attributeName, Class<T> type) {
        return HttpSessions.attribute(request.getSession(false), attributeName, type);
    }

    @Nonnull
    public static <T> Optional<T> attribute(@Nullable HttpSession session, String attributeName, Class<T> type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attributeName) ? 1 : 0) != 0, (String)"attributeName is required to be non-null & not empty: %s", (Object)attributeName);
        Preconditions.checkNotNull(type, (Object)"type is required");
        if (session == null) {
            return Optional.empty();
        }
        Object val = session.getAttribute(attributeName);
        if (val == null) {
            return Optional.empty();
        }
        if (type != val.getClass()) {
            throw new IllegalStateException(String.format("Expected type '%s', got type '%s' for session attribute '%s'", type, val.getClass(), attributeName));
        }
        return Optional.of(val);
    }

    private HttpSessions() {
        StaticUtilityClass.throwCannotInstantiateError(this.getClass());
    }
}

