/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.RestStatus;

public final class BulkItemResponseToFailedFlag {
    @NotNull
    public final BulkItemResponse response;
    public final boolean failed;
    @NotNull
    public final String id;

    public BulkItemResponseToFailedFlag(@NotNull BulkItemResponse response, boolean failed) {
        this.response = response;
        this.failed = failed;
        this.id = response.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkItemResponseToFailedFlag)) {
            return false;
        }
        BulkItemResponseToFailedFlag that = (BulkItemResponseToFailedFlag)o;
        if (this.failed != that.failed) {
            return false;
        }
        if (!this.response.equals(that.response)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.response.hashCode();
        result = 31 * result + (this.failed ? 1 : 0);
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return "BulkItemResponseToFailedFlag{response=" + this.response + ", failed=" + this.failed + ", id='" + this.id + "'}";
    }

    public RestStatus status() {
        return this.response.status();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.response.toXContent(builder, params);
    }

    public int getItemId() {
        return this.response.getItemId();
    }

    public DocWriteRequest.OpType getOpType() {
        return this.response.getOpType();
    }

    public String getIndex() {
        return this.response.getIndex();
    }

    public long getVersion() {
        return this.response.getVersion();
    }

    public <T extends DocWriteResponse> T getResponse() {
        return (T)this.response.getResponse();
    }

    public boolean isFailed() {
        return this.response.isFailed();
    }

    public String getFailureMessage() {
        return this.response.getFailureMessage();
    }

    public BulkItemResponse.Failure getFailure() {
        return this.response.getFailure();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.response.writeTo(out);
    }

    public void writeThin(StreamOutput out) throws IOException {
        this.response.writeThin(out);
    }

    public boolean isFragment() {
        return this.response.isFragment();
    }
}

