/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.IndexTemplatesExistRequest;
import org.opensearch.client.indices.PutIndexTemplateRequest;
import org.opensearch.common.xcontent.XContentType;
import org.slf4j.Logger;

public class IndexCreation {
    public static synchronized void checkOrCreateIndex(RestHighLevelClient client, String indexName, String boltType, Logger log) throws IOException {
        boolean indexExists = client.indices().exists(new GetIndexRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        log.info("Index '{}' exists? {}", (Object)indexName, (Object)indexExists);
        if (!indexExists) {
            boolean created = IndexCreation.createIndex(client, indexName, boltType + ".mapping");
            log.info("Index '{}' created? {} using {}", new Object[]{indexName, created, boltType + ".mapping"});
        }
    }

    public static synchronized void checkOrCreateIndexTemplate(RestHighLevelClient client, String boltType, Logger log) throws IOException {
        String templateName = boltType + "-template";
        boolean templateExists = client.indices().existsTemplate(new IndexTemplatesExistRequest(new String[]{templateName}), RequestOptions.DEFAULT);
        log.info("Template '{}' exists? {}", (Object)templateName, (Object)templateExists);
        if (!templateExists) {
            boolean created = IndexCreation.createTemplate(client, templateName, boltType + ".mapping");
            log.info("templateExists '{}' created? {}", (Object)templateName, (Object)created);
        }
    }

    private static boolean createTemplate(RestHighLevelClient client, String templateName, String resourceName) {
        try {
            PutIndexTemplateRequest createIndexRequest = new PutIndexTemplateRequest(templateName);
            URL mapping = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            String jsonIndexConfiguration = Resources.toString((URL)mapping, (Charset)Charsets.UTF_8);
            createIndexRequest.source(jsonIndexConfiguration, XContentType.JSON);
            AcknowledgedResponse createIndexResponse = client.indices().putTemplate(createIndexRequest, RequestOptions.DEFAULT);
            return createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean createIndex(RestHighLevelClient client, String indexName, String resourceName) {
        try {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            URL mapping = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            String jsonIndexConfiguration = Resources.toString((URL)mapping, (Charset)Charsets.UTF_8);
            createIndexRequest.source(jsonIndexConfiguration, XContentType.JSON);
            CreateIndexResponse createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            return createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            return false;
        }
    }
}

