/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch.filtering;

import com.digitalpebble.stormcrawler.JSONResource;
import com.digitalpebble.stormcrawler.Metadata;
import com.digitalpebble.stormcrawler.filtering.URLFilter;
import com.digitalpebble.stormcrawler.opensearch.OpenSearchConnection;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONURLFilterWrapper
extends URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONURLFilterWrapper.class);
    private URLFilter delegatedURLFilter;

    public void configure(final @NotNull Map<String, Object> stormConf, @NotNull JsonNode filterParams) {
        String urlfilterclass = null;
        JsonNode delegateNode = filterParams.get("delegate");
        if (delegateNode == null) {
            throw new RuntimeException("delegateNode undefined!");
        }
        JsonNode node = delegateNode.get("class");
        if (node != null && node.isTextual()) {
            urlfilterclass = node.asText();
        }
        if (urlfilterclass == null) {
            throw new RuntimeException("urlfilter.class undefined!");
        }
        try {
            Class<?> filterClass = Class.forName(urlfilterclass);
            boolean subClassOK = URLFilter.class.isAssignableFrom(filterClass);
            if (!subClassOK) {
                throw new RuntimeException("Filter " + urlfilterclass + " does not extend URLFilter");
            }
            this.delegatedURLFilter = (URLFilter)filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!JSONResource.class.isInstance(this.delegatedURLFilter)) {
                throw new RuntimeException("Filter " + urlfilterclass + " does not implement JSONResource");
            }
        }
        catch (Exception e) {
            LOG.error("Can't setup {}: {}", (Object)urlfilterclass, (Object)e);
            throw new RuntimeException("Can't setup " + urlfilterclass, e);
        }
        node = delegateNode.get("params");
        this.delegatedURLFilter.configure(stormConf, node);
        int refreshRate = 600;
        node = filterParams.get("refresh");
        if (node != null && node.isInt()) {
            refreshRate = node.asInt(refreshRate);
        }
        final JSONResource resource = (JSONResource)this.delegatedURLFilter;
        new Timer().schedule(new TimerTask(){
            private RestHighLevelClient esClient;

            @Override
            public void run() {
                if (this.esClient == null) {
                    try {
                        this.esClient = OpenSearchConnection.getClient(stormConf, "config");
                    }
                    catch (Exception e) {
                        LOG.error("Exception while creating ES connection", (Throwable)e);
                    }
                }
                if (this.esClient != null) {
                    LOG.info("Reloading json resources from ES");
                    try {
                        GetResponse response = this.esClient.get(new GetRequest("config", resource.getResourceFile()), RequestOptions.DEFAULT);
                        resource.loadJSONResources((InputStream)new ByteArrayInputStream(response.getSourceAsBytes()));
                    }
                    catch (Exception e) {
                        LOG.error("Can't load config from ES", (Throwable)e);
                    }
                }
            }
        }, 0L, (long)(refreshRate * 1000));
    }

    @Nullable
    public String filter(@Nullable URL sourceUrl, @Nullable Metadata sourceMetadata, @NotNull String urlToFilter) {
        return this.delegatedURLFilter.filter(sourceUrl, sourceMetadata, urlToFilter);
    }
}

