/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch.metrics;

import com.digitalpebble.stormcrawler.opensearch.IndexCreation;
import com.digitalpebble.stormcrawler.opensearch.OpenSearchConnection;
import com.digitalpebble.stormcrawler.util.ConfUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.task.IErrorReporter;
import org.apache.storm.task.TopologyContext;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.XContentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConsumer
implements IMetricsConsumer {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final String OSBoltType = "metrics";
    private static final String OSMetricsIndexNameParamName = "opensearch.metrics.index.name";
    private String indexName;
    private OpenSearchConnection connection;
    private String stormID;
    private SimpleDateFormat dateFormat;

    public void prepare(Map stormConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        this.indexName = ConfUtils.getString((Map)stormConf, (String)OSMetricsIndexNameParamName, (String)OSBoltType);
        this.stormID = context.getStormId();
        if (registrationArgument != null) {
            this.dateFormat = new SimpleDateFormat((String)registrationArgument);
            this.LOG.info("Using date format {}", registrationArgument);
        }
        try {
            this.connection = OpenSearchConnection.getConnection(stormConf, OSBoltType);
        }
        catch (Exception e1) {
            this.LOG.error("Can't connect to OpenSearch", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        try {
            IndexCreation.checkOrCreateIndexTemplate(this.connection.getClient(), OSBoltType, this.LOG);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        Date now = new Date();
        for (IMetricsConsumer.DataPoint dataPoint : dataPoints) {
            this.handleDataPoints(taskInfo, dataPoint.name, dataPoint.value, now);
        }
    }

    private void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, String nameprefix, Object value, Date now) {
        if (value instanceof Number) {
            this.indexDataPoint(taskInfo, now, nameprefix, ((Number)value).doubleValue());
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String newnameprefix = nameprefix + "." + entry.getKey();
                this.handleDataPoints(taskInfo, newnameprefix, entry.getValue(), now);
            }
        } else if (value instanceof Collection) {
            for (Object collectionObj : (Collection)value) {
                this.handleDataPoints(taskInfo, nameprefix, collectionObj, now);
            }
        } else {
            this.LOG.warn("Found data point value {} of {}", (Object)nameprefix, (Object)value.getClass().toString());
        }
    }

    private String getIndexName(Date timestamp) {
        if (this.dateFormat == null) {
            return this.indexName;
        }
        StringBuilder sb = new StringBuilder(this.indexName);
        sb.append("-").append(this.dateFormat.format(timestamp));
        return sb.toString();
    }

    private void indexDataPoint(IMetricsConsumer.TaskInfo taskInfo, Date timestamp, String name, double value) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.field("stormId", this.stormID);
            builder.field("srcComponentId", taskInfo.srcComponentId);
            builder.field("srcTaskId", taskInfo.srcTaskId);
            builder.field("srcWorkerHost", taskInfo.srcWorkerHost);
            builder.field("srcWorkerPort", taskInfo.srcWorkerPort);
            builder.field("name", name);
            builder.field("value", value);
            builder.field("timestamp", (Object)timestamp);
            builder.endObject();
            IndexRequest indexRequest = new IndexRequest(this.getIndexName(timestamp)).source(builder);
            this.connection.addToProcessor((DocWriteRequest<?>)indexRequest);
        }
        catch (Exception e) {
            this.LOG.error("problem when building request for ES", (Throwable)e);
        }
    }
}

