/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch.metrics;

import com.digitalpebble.stormcrawler.opensearch.OpenSearchConnection;
import com.digitalpebble.stormcrawler.util.ConfUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.opensearch.action.ActionListener;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.core.CountResponse;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMetricsBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(StatusMetricsBolt.class);
    private static final String OSBoltType = "status";
    private static final String OSStatusIndexNameParamName = "opensearch.status.index.name";
    private String indexName;
    private OpenSearchConnection connection;
    private Map<String, Long> latestStatusCounts = new HashMap<String, Long>(6);
    private int freqStats = 60;
    private OutputCollector _collector;
    private transient StatusActionListener[] listeners;

    public void prepare(Map<String, Object> stormConf, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
        this.indexName = ConfUtils.getString(stormConf, (String)OSStatusIndexNameParamName, (String)OSBoltType);
        try {
            this.connection = OpenSearchConnection.getConnection(stormConf, OSBoltType);
        }
        catch (Exception e1) {
            LOG.error("Can't connect to ElasticSearch", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        context.registerMetric("status.count", () -> this.latestStatusCounts, this.freqStats);
        this.listeners = new StatusActionListener[6];
        this.listeners[0] = new StatusActionListener("DISCOVERED");
        this.listeners[1] = new StatusActionListener("FETCHED");
        this.listeners[2] = new StatusActionListener("FETCH_ERROR");
        this.listeners[3] = new StatusActionListener("REDIRECTION");
        this.listeners[4] = new StatusActionListener("ERROR");
        this.listeners[5] = new StatusActionListener("TOTAL");
    }

    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.put((Object)"topology.tick.tuple.freq.secs", (Object)this.freqStats);
        return conf;
    }

    public void execute(Tuple input) {
        this._collector.ack(input);
        if (!TupleUtils.isTick((Tuple)input)) {
            return;
        }
        for (StatusActionListener listener : this.listeners) {
            if (!listener.isReady()) {
                LOG.debug("Not ready to get counts for status {}", (Object)listener.name);
                continue;
            }
            CountRequest request = new CountRequest(new String[]{this.indexName});
            if (!listener.name.equalsIgnoreCase("TOTAL")) {
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)OSBoltType, (String)listener.name));
                request.source(sourceBuilder);
            }
            listener.busy();
            this.connection.getClient().countAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    public void cleanup() {
        this.connection.close();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    private class StatusActionListener
    implements ActionListener<CountResponse> {
        private final String name;
        private boolean ready = true;

        public boolean isReady() {
            return this.ready;
        }

        public void busy() {
            this.ready = false;
        }

        StatusActionListener(String statusName) {
            this.name = statusName;
        }

        public void onResponse(CountResponse response) {
            this.ready = true;
            LOG.debug("Got {} counts for status:{}", (Object)response.getCount(), (Object)this.name);
            StatusMetricsBolt.this.latestStatusCounts.put(this.name, response.getCount());
        }

        public void onFailure(Exception e) {
            this.ready = true;
            LOG.error("Failure when getting counts for status:{}", (Object)this.name, (Object)e);
        }
    }
}

