/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.opensearch.parse.filter;

import com.digitalpebble.stormcrawler.JSONResource;
import com.digitalpebble.stormcrawler.opensearch.OpenSearchConnection;
import com.digitalpebble.stormcrawler.parse.ParseFilter;
import com.digitalpebble.stormcrawler.parse.ParseResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;

public class JSONResourceWrapper
extends ParseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONResourceWrapper.class);
    private ParseFilter delegatedParseFilter;

    public void configure(final @NotNull Map<String, Object> stormConf, @NotNull JsonNode filterParams) {
        String parsefilterclass = null;
        JsonNode delegateNode = filterParams.get("delegate");
        if (delegateNode == null) {
            throw new RuntimeException("delegateNode undefined!");
        }
        JsonNode node = delegateNode.get("class");
        if (node != null && node.isTextual()) {
            parsefilterclass = node.asText();
        }
        if (parsefilterclass == null) {
            throw new RuntimeException("parsefilter.class undefined!");
        }
        try {
            Class<?> filterClass = Class.forName(parsefilterclass);
            boolean subClassOK = ParseFilter.class.isAssignableFrom(filterClass);
            if (!subClassOK) {
                throw new RuntimeException("Filter " + parsefilterclass + " does not extend ParseFilter");
            }
            this.delegatedParseFilter = (ParseFilter)filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!JSONResource.class.isInstance(this.delegatedParseFilter)) {
                throw new RuntimeException("Filter " + parsefilterclass + " does not implement JSONResource");
            }
        }
        catch (Exception e) {
            LOG.error("Can't setup {}: {}", (Object)parsefilterclass, (Object)e);
            throw new RuntimeException("Can't setup " + parsefilterclass, e);
        }
        node = delegateNode.get("params");
        this.delegatedParseFilter.configure(stormConf, node);
        int refreshRate = 600;
        node = filterParams.get("refresh");
        if (node != null && node.isInt()) {
            refreshRate = node.asInt(refreshRate);
        }
        final JSONResource resource = (JSONResource)this.delegatedParseFilter;
        new Timer().schedule(new TimerTask(){
            private RestHighLevelClient esClient;

            @Override
            public void run() {
                if (this.esClient == null) {
                    try {
                        this.esClient = OpenSearchConnection.getClient(stormConf, "config");
                    }
                    catch (Exception e) {
                        LOG.error("Exception while creating OpenSearch connection", (Throwable)e);
                    }
                }
                if (this.esClient != null) {
                    LOG.info("Reloading json resources from OpenSearch");
                    try {
                        GetResponse response = this.esClient.get(new GetRequest("config", resource.getResourceFile()), RequestOptions.DEFAULT);
                        resource.loadJSONResources((InputStream)new ByteArrayInputStream(response.getSourceAsBytes()));
                    }
                    catch (Exception e) {
                        LOG.error("Can't load config from OpenSearch", (Throwable)e);
                    }
                }
            }
        }, 0L, (long)(refreshRate * 1000));
    }

    public void filter(String URL2, byte[] content, DocumentFragment doc, ParseResult parse) {
        this.delegatedParseFilter.filter(URL2, content, doc, parse);
    }
}

